/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.tcpunixsocketproxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProxyThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(ProxyThread.class);
    private static final int COPY_BUFFER_SIZE = 4096;

    public ProxyThread(Socket clientSocket, Socket serverSocket) throws IOException {
        InputStream fromClient = clientSocket.getInputStream();
        OutputStream toClient = clientSocket.getOutputStream();
        InputStream fromServer = serverSocket.getInputStream();
        OutputStream toServer = serverSocket.getOutputStream();
        Thread clientToServerThread = new Thread(() -> {
            this.copyUntilFailure(fromClient, toServer);
            logger.trace("C->S died, closing sockets");
            this.quietlyClose(serverSocket);
            this.quietlyClose(clientSocket);
        });
        clientToServerThread.start();
        Thread serverToClientThread = new Thread(() -> {
            this.copyUntilFailure(fromServer, toClient);
            logger.trace("S->C died, closing sockets");
            this.quietlyClose(serverSocket);
            this.quietlyClose(clientSocket);
        });
        serverToClientThread.start();
    }

    private void copyUntilFailure(InputStream from, OutputStream to) {
        byte[] buffer = new byte[4096];
        try {
            int read;
            while ((read = from.read(buffer)) != -1) {
                to.write(buffer, 0, read);
                to.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void quietlyClose(Socket socket) {
        if (socket != null && !socket.isClosed()) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

