/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.wait;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;

public class HostPortWaitStrategy
extends GenericContainer.AbstractWaitStrategy {
    @Override
    protected void waitUntilReady() {
        Integer port = this.getLivenessCheckPort();
        if (null == port) {
            return;
        }
        String ipAddress = this.container.getContainerIpAddress();
        try {
            Unreliables.retryUntilSuccess((int)this.startupTimeout.getSeconds(), TimeUnit.SECONDS, () -> {
                this.getRateLimiter().doWhenReady(() -> {
                    try {
                        new Socket(ipAddress, (int)port).close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                return true;
            });
        }
        catch (TimeoutException e) {
            throw new ContainerLaunchException("Timed out waiting for container port to open (" + ipAddress + ":" + port + " should be listening)");
        }
    }
}

