/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.shaded.com.github.dockerjava.core.DefaultDockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;

public class UnixSocketClientProviderStrategy
extends DockerClientProviderStrategy {
    protected static final String DOCKER_SOCK_PATH = "/var/run/docker.sock";
    private static final String SOCKET_LOCATION = "unix:///var/run/docker.sock";
    private static final int SOCKET_FILE_MODE_MASK = 49152;

    @Override
    public void test() throws DockerClientProviderStrategy.InvalidConfigurationException {
        if (!System.getProperty("os.name").toLowerCase().contains("linux")) {
            throw new DockerClientProviderStrategy.InvalidConfigurationException("this strategy is only applicable to Linux");
        }
        try {
            this.config = this.tryConfiguration(SOCKET_LOCATION);
            LOGGER.info("Accessing docker with local Unix socket");
        }
        catch (Exception e) {
            throw new DockerClientProviderStrategy.InvalidConfigurationException("ping failed", e);
        }
    }

    @NotNull
    protected DockerClientConfig tryConfiguration(String dockerHost) {
        Integer mode;
        Path dockerSocketFile = Paths.get(DOCKER_SOCK_PATH, new String[0]);
        try {
            mode = (Integer)Files.getAttribute(dockerSocketFile, "unix:mode", new LinkOption[0]);
        }
        catch (IOException e) {
            throw new DockerClientProviderStrategy.InvalidConfigurationException("Could not find unix domain socket", e);
        }
        if ((mode & 0xC000) != 49152) {
            throw new DockerClientProviderStrategy.InvalidConfigurationException("Found docker unix domain socket but file mode was not as expected (expected: srwxr-xr-x). This problem is possibly due to occurrence of this issue in the past: https://github.com/docker/docker/issues/13121");
        }
        this.config = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(dockerHost).withDockerTlsVerify(false).build();
        this.client = this.getClientForConfig(this.config);
        this.ping(this.client, 10);
        return this.config;
    }

    @Override
    public String getDescription() {
        return "local Unix socket (unix:///var/run/docker.sock)";
    }
}

