/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images.builder.traits;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.images.builder.traits.BuildContextBuilderTrait;

public interface FilesTrait<SELF extends FilesTrait<SELF> & BuildContextBuilderTrait<SELF>> {
    default public SELF withFileFromFile(String path, File file) {
        return this.withFileFromPath(path, file.toPath());
    }

    default public SELF withFileFromPath(String path, final Path filePath) {
        return (SELF)((FilesTrait)((BuildContextBuilderTrait)((Object)this)).withFileFromTransferable(path, new Transferable(){

            @Override
            public long getSize() {
                try {
                    return Files.size(filePath);
                }
                catch (IOException e) {
                    throw new RuntimeException("Can't get size from " + filePath, e);
                }
            }

            @Override
            public int getFileMode() {
                return 0x81A4 | (Files.isExecutable(filePath) ? 493 : 0);
            }

            @Override
            public void transferTo(OutputStream outputStream) {
                try {
                    Files.copy(filePath, outputStream);
                }
                catch (IOException e) {
                    throw new RuntimeException("Can't transfer file " + filePath, e);
                }
            }
        }));
    }
}

