/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.api.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonParser;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.testcontainers.shaded.com.fasterxml.jackson.core.ObjectCodec;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.node.NullNode;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Volume;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class Volumes {
    private Volume[] volumes;

    public Volumes(Volume ... volumes) {
        this.volumes = volumes;
    }

    public Volumes(List<Volume> volumes) {
        this.volumes = volumes.toArray(new Volume[volumes.size()]);
    }

    public Volume[] getVolumes() {
        return this.volumes;
    }

    public static class Deserializer
    extends JsonDeserializer<Volumes> {
        @Override
        public Volumes deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            ArrayList<Volume> volumes = new ArrayList<Volume>();
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            Iterator<Map.Entry<String, JsonNode>> it = node.fields();
            while (it.hasNext()) {
                Map.Entry<String, JsonNode> field = it.next();
                if (field.getValue().equals(NullNode.getInstance())) continue;
                String path = field.getKey();
                Volume volume = new Volume(path);
                volumes.add(volume);
            }
            return new Volumes(volumes.toArray(new Volume[0]));
        }
    }

    public static class Serializer
    extends JsonSerializer<Volumes> {
        @Override
        public void serialize(Volumes volumes, JsonGenerator jsonGen, SerializerProvider serProvider) throws IOException, JsonProcessingException {
            jsonGen.writeStartObject();
            for (Volume volume : volumes.getVolumes()) {
                jsonGen.writeFieldName(volume.getPath());
                jsonGen.writeStartObject();
                jsonGen.writeEndObject();
            }
            jsonGen.writeEndObject();
        }
    }
}

