/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.command;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.DockerClientException;
import org.testcontainers.shaded.com.github.dockerjava.api.model.WaitResponse;
import org.testcontainers.shaded.com.github.dockerjava.core.async.ResultCallbackTemplate;
import org.testcontainers.shaded.javax.annotation.CheckForNull;

public class WaitContainerResultCallback
extends ResultCallbackTemplate<WaitContainerResultCallback, WaitResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaitContainerResultCallback.class);
    @CheckForNull
    private WaitResponse waitResponse = null;

    @Override
    public void onNext(WaitResponse waitResponse) {
        this.waitResponse = waitResponse;
        LOGGER.debug(waitResponse.toString());
    }

    public Integer awaitStatusCode() {
        try {
            this.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new DockerClientException("", e);
        }
        return this.getStatusCode();
    }

    public Integer awaitStatusCode(long timeout, TimeUnit timeUnit) {
        try {
            if (!this.awaitCompletion(timeout, timeUnit)) {
                throw new DockerClientException("Awaiting status code timeout.");
            }
        }
        catch (InterruptedException e) {
            throw new DockerClientException("Awaiting status code interrupted: ", e);
        }
        return this.getStatusCode();
    }

    private Integer getStatusCode() {
        if (this.waitResponse == null) {
            throw new DockerClientException("Error while wait container");
        }
        return this.waitResponse.getStatusCode();
    }
}

