/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.startupcheck;

import java.time.Duration;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.shaded.com.github.dockerjava.api.DockerClient;
import org.testcontainers.shaded.com.github.dockerjava.api.command.InspectContainerResponse;
import org.testcontainers.utility.DockerStatus;

public class MinimumDurationRunningStartupCheckStrategy
extends StartupCheckStrategy {
    @NotNull
    private final Duration minimumRunningDuration;

    public MinimumDurationRunningStartupCheckStrategy(@NotNull Duration minimumRunningDuration) {
        this.minimumRunningDuration = minimumRunningDuration;
    }

    @Override
    public StartupCheckStrategy.StartupStatus checkStartupState(DockerClient dockerClient, String containerId) {
        Instant now = Instant.now();
        InspectContainerResponse.ContainerState state = this.getCurrentState(dockerClient, containerId);
        if (DockerStatus.isContainerRunning(state, this.minimumRunningDuration, now)) {
            return StartupCheckStrategy.StartupStatus.SUCCESSFUL;
        }
        if (DockerStatus.isContainerStopped(state)) {
            return StartupCheckStrategy.StartupStatus.FAILED;
        }
        return StartupCheckStrategy.StartupStatus.NOT_YET_KNOWN;
    }
}

