/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images.builder;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.profiler.Profiler;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.images.builder.traits.BuildContextBuilderTrait;
import org.testcontainers.images.builder.traits.ClasspathTrait;
import org.testcontainers.images.builder.traits.DockerfileTrait;
import org.testcontainers.images.builder.traits.FilesTrait;
import org.testcontainers.images.builder.traits.StringsTrait;
import org.testcontainers.shaded.com.github.dockerjava.api.DockerClient;
import org.testcontainers.shaded.com.github.dockerjava.api.command.BuildImageCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.DockerClientException;
import org.testcontainers.shaded.com.github.dockerjava.api.model.BuildResponseItem;
import org.testcontainers.shaded.com.github.dockerjava.core.command.BuildImageResultCallback;
import org.testcontainers.shaded.com.google.common.collect.Sets;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerLoggerFactory;
import org.testcontainers.utility.LazyFuture;

public class ImageFromDockerfile
extends LazyFuture<String>
implements BuildContextBuilderTrait<ImageFromDockerfile>,
ClasspathTrait<ImageFromDockerfile>,
FilesTrait<ImageFromDockerfile>,
StringsTrait<ImageFromDockerfile>,
DockerfileTrait<ImageFromDockerfile> {
    private static final Logger log = LoggerFactory.getLogger(ImageFromDockerfile.class);
    private static final Set<String> imagesToDelete = Sets.newConcurrentHashSet();
    private final String dockerImageName;
    private boolean deleteOnExit = true;
    private final Map<String, Transferable> transferables = new HashMap<String, Transferable>();

    public ImageFromDockerfile() {
        this("testcontainers/" + Base58.randomString(16).toLowerCase());
    }

    public ImageFromDockerfile(String dockerImageName) {
        this(dockerImageName, true);
    }

    public ImageFromDockerfile(String dockerImageName, boolean deleteOnExit) {
        this.dockerImageName = dockerImageName;
        this.deleteOnExit = deleteOnExit;
    }

    @Override
    public ImageFromDockerfile withFileFromTransferable(String path, Transferable transferable) {
        Transferable oldValue = this.transferables.put(path, transferable);
        if (oldValue != null) {
            log.warn("overriding previous mapping for '{}'", (Object)path);
        }
        return this;
    }

    @Override
    protected final String resolve() {
        final Logger logger = DockerLoggerFactory.getLogger(this.dockerImageName);
        Profiler profiler = new Profiler("Rule creation - build image");
        profiler.setLogger(logger);
        DockerClient dockerClient = DockerClientFactory.instance().client();
        try {
            if (this.deleteOnExit) {
                imagesToDelete.add(this.dockerImageName);
            }
            BuildImageResultCallback resultCallback = new BuildImageResultCallback(){

                @Override
                public void onNext(BuildResponseItem item) {
                    super.onNext(item);
                    if (item.isErrorIndicated()) {
                        logger.error(item.getErrorDetail().getMessage());
                    } else {
                        logger.debug(StringUtils.chomp(item.getStream(), "\n"));
                    }
                }
            };
            PipedInputStream in = new PipedInputStream();
            PipedOutputStream out = new PipedOutputStream(in);
            profiler.start("Configure image");
            BuildImageCmd buildImageCmd = dockerClient.buildImageCmd(in);
            this.configure(buildImageCmd);
            profiler.start("Build image");
            BuildImageResultCallback exec = buildImageCmd.exec(resultCallback);
            profiler.start("Send context as TAR");
            try (TarArchiveOutputStream tarArchive = new TarArchiveOutputStream(new GZIPOutputStream(out));){
                for (Map.Entry<String, Transferable> entry : this.transferables.entrySet()) {
                    TarArchiveEntry tarEntry = new TarArchiveEntry(entry.getKey());
                    Transferable transferable = entry.getValue();
                    tarEntry.setSize(transferable.getSize());
                    tarEntry.setMode(transferable.getFileMode());
                    tarArchive.putArchiveEntry(tarEntry);
                    transferable.transferTo(tarArchive);
                    tarArchive.closeArchiveEntry();
                }
                tarArchive.finish();
            }
            profiler.start("Wait for an image id");
            exec.awaitImageId();
            String string = this.dockerImageName;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Can't close DockerClient", e);
        }
        finally {
            profiler.stop().log();
        }
    }

    protected void configure(BuildImageCmd buildImageCmd) {
        buildImageCmd.withTag(this.getDockerImageName());
    }

    public String getDockerImageName() {
        return this.dockerImageName;
    }

    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }

    public Map<String, Transferable> getTransferables() {
        return this.transferables;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            DockerClient dockerClientForCleaning = DockerClientFactory.instance().client();
            try {
                for (String dockerImageName : imagesToDelete) {
                    log.info("Removing image tagged {}", (Object)dockerImageName);
                    try {
                        dockerClientForCleaning.removeImageCmd(dockerImageName).withForce(true).exec();
                    }
                    catch (Throwable e) {
                        log.warn("Unable to delete image " + dockerImageName, e);
                    }
                }
            }
            catch (DockerClientException e) {
                throw new RuntimeException(e);
            }
        }));
    }
}

