/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images.builder.traits;

import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import org.testcontainers.images.builder.traits.BuildContextBuilderTrait;
import org.testcontainers.images.builder.traits.FilesTrait;

public interface ClasspathTrait<SELF extends ClasspathTrait<SELF> & BuildContextBuilderTrait<SELF>> {
    default public SELF withFileFromClasspath(String path, String resourcePath) {
        URL resource = ClasspathTrait.class.getClassLoader().getResource(resourcePath);
        if (resource == null) {
            throw new IllegalArgumentException("Could not find classpath resource at provided path: " + resourcePath);
        }
        String resourceFilePath = new File(resource.getFile()).getAbsolutePath();
        return (SELF)((ClasspathTrait)((FilesTrait)((Object)this)).withFileFromPath(path, Paths.get(resourceFilePath, new String[0])));
    }
}

