/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.async;

import java.io.IOException;
import java.io.InputStream;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonParser;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonToken;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.testcontainers.shaded.com.github.dockerjava.api.async.ResultCallback;
import org.testcontainers.shaded.com.github.dockerjava.core.async.ResponseStreamProcessor;

public class JsonStreamProcessor<T>
implements ResponseStreamProcessor<T> {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Class<T> clazz;

    public JsonStreamProcessor(Class<T> clazz) {
        this.clazz = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void processResponseStream(InputStream response, ResultCallback<T> resultCallback) {
        resultCallback.onStart(response);
        OBJECT_MAPPER.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
        try {
            JsonParser jp = JSON_FACTORY.createParser(response);
            Boolean closed = jp.isClosed();
            JsonToken nextToken = jp.nextToken();
            while (closed == false) {
                if (nextToken == null) return;
                if (nextToken == JsonToken.END_OBJECT) return;
                try {
                    ObjectNode objectNode = (ObjectNode)OBJECT_MAPPER.readTree(jp);
                    if (!objectNode.isEmpty(null)) {
                        T next = OBJECT_MAPPER.treeToValue(objectNode, this.clazz);
                        resultCallback.onNext(next);
                    }
                }
                catch (Exception e) {
                    resultCallback.onError(e);
                }
                closed = jp.isClosed();
                nextToken = jp.nextToken();
            }
            return;
        }
        catch (Throwable t) {
            resultCallback.onError(t);
            return;
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                resultCallback.onError(e);
            }
            finally {
                resultCallback.onComplete();
            }
        }
    }
}

