/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.command;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.DockerClientException;
import org.testcontainers.shaded.com.github.dockerjava.api.model.PullResponseItem;
import org.testcontainers.shaded.com.github.dockerjava.core.async.ResultCallbackTemplate;
import org.testcontainers.shaded.javax.annotation.CheckForNull;

public class PullImageResultCallback
extends ResultCallbackTemplate<PullImageResultCallback, PullResponseItem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PullImageResultCallback.class);
    @CheckForNull
    private PullResponseItem latestItem = null;

    @Override
    public void onNext(PullResponseItem item) {
        this.latestItem = item;
        LOGGER.debug(item.toString());
    }

    public void awaitSuccess() {
        try {
            this.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new DockerClientException("", e);
        }
        if (this.latestItem == null) {
            throw new DockerClientException("Could not pull image");
        }
        if (!this.latestItem.isPullSuccessIndicated()) {
            String message = this.latestItem.getError() != null ? this.latestItem.getError() : this.latestItem.getStatus();
            throw new DockerClientException("Could not pull image: " + message);
        }
    }
}

