/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.netty.handler;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.testcontainers.shaded.com.github.dockerjava.netty.handler.HttpResponseHandler;
import org.testcontainers.shaded.io.netty.channel.ChannelHandlerContext;
import org.testcontainers.shaded.io.netty.handler.codec.http.FullHttpResponse;
import org.testcontainers.shaded.io.netty.handler.codec.http.HttpClientUpgradeHandler;
import org.testcontainers.shaded.io.netty.handler.codec.http.HttpRequest;

public class HttpConnectionHijackHandler
implements HttpClientUpgradeHandler.UpgradeCodec {
    private CountDownLatch latch = new CountDownLatch(1);
    private HttpResponseHandler httpResponseHandler;

    public HttpConnectionHijackHandler(HttpResponseHandler httpResponseHandler) {
        this.httpResponseHandler = httpResponseHandler;
    }

    @Override
    public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) throws Exception {
        this.httpResponseHandler.channelRead(ctx, upgradeResponse);
        ctx.pipeline().addLast(this.httpResponseHandler);
        this.latch.countDown();
    }

    @Override
    public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext ctx, HttpRequest upgradeRequest) {
        return Collections.emptyList();
    }

    @Override
    public CharSequence protocol() {
        return "tcp";
    }

    public void awaitUpgrade() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

