/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.io.netty.handler.flush;

import org.testcontainers.shaded.io.netty.channel.ChannelDuplexHandler;
import org.testcontainers.shaded.io.netty.channel.ChannelHandlerContext;
import org.testcontainers.shaded.io.netty.channel.ChannelPromise;
import org.testcontainers.shaded.io.netty.util.internal.ObjectUtil;

public class FlushConsolidationHandler
extends ChannelDuplexHandler {
    private final int explicitFlushAfterFlushes;
    private int flushPendingCount;
    private boolean readInprogess;

    public FlushConsolidationHandler() {
        this(256);
    }

    public FlushConsolidationHandler(int explicitFlushAfterFlushes) {
        this.explicitFlushAfterFlushes = ObjectUtil.checkPositive(explicitFlushAfterFlushes, "explicitFlushAfterFlushes");
    }

    @Override
    public void flush(ChannelHandlerContext ctx) throws Exception {
        if (this.readInprogess) {
            if (++this.flushPendingCount == this.explicitFlushAfterFlushes) {
                this.flushPendingCount = 0;
                ctx.flush();
            }
            return;
        }
        ctx.flush();
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.flushIfNeeded(ctx, true);
        ctx.fireChannelReadComplete();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.readInprogess = true;
        ctx.fireChannelRead(msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.flushIfNeeded(ctx, true);
        ctx.fireExceptionCaught(cause);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.flushIfNeeded(ctx, true);
        ctx.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.flushIfNeeded(ctx, true);
        ctx.close(promise);
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (!ctx.channel().isWritable()) {
            this.flushIfNeeded(ctx, false);
        }
        ctx.fireChannelWritabilityChanged();
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.flushIfNeeded(ctx, false);
    }

    private void flushIfNeeded(ChannelHandlerContext ctx, boolean resetReadInProgress) {
        if (resetReadInProgress) {
            this.readInprogess = false;
        }
        if (this.flushPendingCount > 0) {
            this.flushPendingCount = 0;
            ctx.flush();
        }
    }
}

