/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.output;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Frame;
import org.testcontainers.shaded.com.github.dockerjava.core.async.ResultCallbackTemplate;

public class FrameConsumerResultCallback
extends ResultCallbackTemplate<FrameConsumerResultCallback, Frame> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrameConsumerResultCallback.class);
    private Map<OutputFrame.OutputType, Consumer<OutputFrame>> consumers;
    private CountDownLatch completionLatch = new CountDownLatch(1);

    public FrameConsumerResultCallback() {
        this.consumers = new HashMap<OutputFrame.OutputType, Consumer<OutputFrame>>();
    }

    public void addConsumer(OutputFrame.OutputType outputType, Consumer<OutputFrame> consumer) {
        this.consumers.put(outputType, consumer);
    }

    @Override
    public void onNext(Frame frame) {
        OutputFrame outputFrame;
        if (frame != null && (outputFrame = OutputFrame.forFrame(frame)) != null) {
            Consumer<OutputFrame> consumer = this.consumers.get((Object)outputFrame.getType());
            if (consumer == null) {
                LOGGER.error("got frame with type " + (Object)((Object)frame.getStreamType()) + ", for which no handler is configured");
            } else {
                consumer.accept(outputFrame);
            }
        }
    }

    @Override
    public void onError(Throwable throwable) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        for (Consumer<OutputFrame> consumer : new HashSet<Consumer<OutputFrame>>(this.consumers.values())) {
            consumer.accept(OutputFrame.END);
        }
        super.close();
        this.completionLatch.countDown();
    }

    public CountDownLatch getCompletionLatch() {
        return this.completionLatch;
    }
}

