/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.apache.http.impl.auth;

import org.testcontainers.shaded.org.apache.http.annotation.Immutable;
import org.testcontainers.shaded.org.apache.http.auth.AuthScheme;
import org.testcontainers.shaded.org.apache.http.auth.AuthSchemeFactory;
import org.testcontainers.shaded.org.apache.http.auth.AuthSchemeProvider;
import org.testcontainers.shaded.org.apache.http.impl.auth.KerberosScheme;
import org.testcontainers.shaded.org.apache.http.params.HttpParams;
import org.testcontainers.shaded.org.apache.http.protocol.HttpContext;

@Immutable
public class KerberosSchemeFactory
implements AuthSchemeFactory,
AuthSchemeProvider {
    private final boolean stripPort;
    private final boolean useCanonicalHostname;

    public KerberosSchemeFactory(boolean stripPort, boolean useCanonicalHostname) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = useCanonicalHostname;
    }

    public KerberosSchemeFactory(boolean stripPort) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = true;
    }

    public KerberosSchemeFactory() {
        this(true, true);
    }

    public boolean isStripPort() {
        return this.stripPort;
    }

    public boolean isUseCanonicalHostname() {
        return this.useCanonicalHostname;
    }

    @Override
    public AuthScheme newInstance(HttpParams params) {
        return new KerberosScheme(this.stripPort, this.useCanonicalHostname);
    }

    @Override
    public AuthScheme create(HttpContext context) {
        return new KerberosScheme(this.stripPort, this.useCanonicalHostname);
    }
}

