/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.bouncycastle.tsp;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Boolean;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Integer;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Primitive;
import org.testcontainers.shaded.org.bouncycastle.asn1.DERNull;
import org.testcontainers.shaded.org.bouncycastle.asn1.cms.AttributeTable;
import org.testcontainers.shaded.org.bouncycastle.asn1.ess.ESSCertID;
import org.testcontainers.shaded.org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.testcontainers.shaded.org.bouncycastle.asn1.ess.SigningCertificate;
import org.testcontainers.shaded.org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.testcontainers.shaded.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.testcontainers.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.testcontainers.shaded.org.bouncycastle.asn1.tsp.Accuracy;
import org.testcontainers.shaded.org.bouncycastle.asn1.tsp.MessageImprint;
import org.testcontainers.shaded.org.bouncycastle.asn1.tsp.TSTInfo;
import org.testcontainers.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.testcontainers.shaded.org.bouncycastle.asn1.x509.GeneralName;
import org.testcontainers.shaded.org.bouncycastle.asn1.x509.GeneralNames;
import org.testcontainers.shaded.org.bouncycastle.asn1.x509.IssuerSerial;
import org.testcontainers.shaded.org.bouncycastle.cert.X509CertificateHolder;
import org.testcontainers.shaded.org.bouncycastle.cms.CMSAttributeTableGenerationException;
import org.testcontainers.shaded.org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.testcontainers.shaded.org.bouncycastle.cms.CMSException;
import org.testcontainers.shaded.org.bouncycastle.cms.CMSProcessableByteArray;
import org.testcontainers.shaded.org.bouncycastle.cms.CMSSignedData;
import org.testcontainers.shaded.org.bouncycastle.cms.CMSSignedDataGenerator;
import org.testcontainers.shaded.org.bouncycastle.cms.SignerInfoGenerator;
import org.testcontainers.shaded.org.bouncycastle.operator.DigestCalculator;
import org.testcontainers.shaded.org.bouncycastle.tsp.TSPException;
import org.testcontainers.shaded.org.bouncycastle.tsp.TSPUtil;
import org.testcontainers.shaded.org.bouncycastle.tsp.TimeStampRequest;
import org.testcontainers.shaded.org.bouncycastle.tsp.TimeStampToken;
import org.testcontainers.shaded.org.bouncycastle.util.CollectionStore;
import org.testcontainers.shaded.org.bouncycastle.util.Encodable;
import org.testcontainers.shaded.org.bouncycastle.util.Store;

public class TimeStampTokenGenerator {
    int accuracySeconds = -1;
    int accuracyMillis = -1;
    int accuracyMicros = -1;
    boolean ordering = false;
    GeneralName tsa = null;
    private ASN1ObjectIdentifier tsaPolicyOID;
    private List certs = new ArrayList();
    private List crls = new ArrayList();
    private List attrCerts = new ArrayList();
    private Map otherRevoc = new HashMap();
    private SignerInfoGenerator signerInfoGen;

    public TimeStampTokenGenerator(SignerInfoGenerator signerInfoGenerator, DigestCalculator digestCalculator, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IllegalArgumentException, TSPException {
        this(signerInfoGenerator, digestCalculator, aSN1ObjectIdentifier, false);
    }

    public TimeStampTokenGenerator(final SignerInfoGenerator signerInfoGenerator, DigestCalculator digestCalculator, ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl) throws IllegalArgumentException, TSPException {
        this.signerInfoGen = signerInfoGenerator;
        this.tsaPolicyOID = aSN1ObjectIdentifier;
        if (!signerInfoGenerator.hasAssociatedCertificate()) {
            throw new IllegalArgumentException("SignerInfoGenerator must have an associated certificate");
        }
        X509CertificateHolder x509CertificateHolder = signerInfoGenerator.getAssociatedCertificate();
        TSPUtil.validateCertificate(x509CertificateHolder);
        try {
            OutputStream outputStream = digestCalculator.getOutputStream();
            outputStream.write(x509CertificateHolder.getEncoded());
            outputStream.close();
            if (digestCalculator.getAlgorithmIdentifier().getAlgorithm().equals(OIWObjectIdentifiers.idSHA1)) {
                final ESSCertID eSSCertID = new ESSCertID(digestCalculator.getDigest(), bl ? new IssuerSerial(new GeneralNames(new GeneralName(x509CertificateHolder.getIssuer())), x509CertificateHolder.getSerialNumber()) : null);
                this.signerInfoGen = new SignerInfoGenerator(signerInfoGenerator, new CMSAttributeTableGenerator(){

                    public AttributeTable getAttributes(Map map) throws CMSAttributeTableGenerationException {
                        AttributeTable attributeTable = signerInfoGenerator.getSignedAttributeTableGenerator().getAttributes(map);
                        if (attributeTable.get(PKCSObjectIdentifiers.id_aa_signingCertificate) == null) {
                            return attributeTable.add(PKCSObjectIdentifiers.id_aa_signingCertificate, new SigningCertificate(eSSCertID));
                        }
                        return attributeTable;
                    }
                }, signerInfoGenerator.getUnsignedAttributeTableGenerator());
            } else {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestCalculator.getAlgorithmIdentifier().getAlgorithm());
                final ESSCertIDv2 eSSCertIDv2 = new ESSCertIDv2(algorithmIdentifier, digestCalculator.getDigest(), bl ? new IssuerSerial(new GeneralNames(new GeneralName(x509CertificateHolder.getIssuer())), new ASN1Integer(x509CertificateHolder.getSerialNumber())) : null);
                this.signerInfoGen = new SignerInfoGenerator(signerInfoGenerator, new CMSAttributeTableGenerator(){

                    public AttributeTable getAttributes(Map map) throws CMSAttributeTableGenerationException {
                        AttributeTable attributeTable = signerInfoGenerator.getSignedAttributeTableGenerator().getAttributes(map);
                        if (attributeTable.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2) == null) {
                            return attributeTable.add(PKCSObjectIdentifiers.id_aa_signingCertificateV2, new SigningCertificateV2(eSSCertIDv2));
                        }
                        return attributeTable;
                    }
                }, signerInfoGenerator.getUnsignedAttributeTableGenerator());
            }
        }
        catch (IOException iOException) {
            throw new TSPException("Exception processing certificate.", iOException);
        }
    }

    public void addCertificates(Store store) {
        this.certs.addAll(store.getMatches(null));
    }

    public void addCRLs(Store store) {
        this.crls.addAll(store.getMatches(null));
    }

    public void addAttributeCertificates(Store store) {
        this.attrCerts.addAll(store.getMatches(null));
    }

    public void addOtherRevocationInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier, Store store) {
        this.otherRevoc.put(aSN1ObjectIdentifier, store.getMatches(null));
    }

    public void setAccuracySeconds(int n) {
        this.accuracySeconds = n;
    }

    public void setAccuracyMillis(int n) {
        this.accuracyMillis = n;
    }

    public void setAccuracyMicros(int n) {
        this.accuracyMicros = n;
    }

    public void setOrdering(boolean bl) {
        this.ordering = bl;
    }

    public void setTSA(GeneralName generalName) {
        this.tsa = generalName;
    }

    public TimeStampToken generate(TimeStampRequest timeStampRequest, BigInteger bigInteger, Date date) throws TSPException {
        ASN1Primitive aSN1Primitive;
        ASN1Integer aSN1Integer;
        ASN1Primitive aSN1Primitive2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = timeStampRequest.getMessageImprintAlgOID();
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aSN1ObjectIdentifier, DERNull.INSTANCE);
        MessageImprint messageImprint = new MessageImprint(algorithmIdentifier, timeStampRequest.getMessageImprintDigest());
        Accuracy accuracy = null;
        if (this.accuracySeconds > 0 || this.accuracyMillis > 0 || this.accuracyMicros > 0) {
            aSN1Primitive2 = null;
            if (this.accuracySeconds > 0) {
                aSN1Primitive2 = new ASN1Integer(this.accuracySeconds);
            }
            aSN1Integer = null;
            if (this.accuracyMillis > 0) {
                aSN1Integer = new ASN1Integer(this.accuracyMillis);
            }
            aSN1Primitive = null;
            if (this.accuracyMicros > 0) {
                aSN1Primitive = new ASN1Integer(this.accuracyMicros);
            }
            accuracy = new Accuracy((ASN1Integer)aSN1Primitive2, aSN1Integer, (ASN1Integer)aSN1Primitive);
        }
        aSN1Primitive2 = null;
        if (this.ordering) {
            aSN1Primitive2 = ASN1Boolean.getInstance(this.ordering);
        }
        aSN1Integer = null;
        if (timeStampRequest.getNonce() != null) {
            aSN1Integer = new ASN1Integer(timeStampRequest.getNonce());
        }
        aSN1Primitive = this.tsaPolicyOID;
        if (timeStampRequest.getReqPolicy() != null) {
            aSN1Primitive = timeStampRequest.getReqPolicy();
        }
        TSTInfo tSTInfo = new TSTInfo((ASN1ObjectIdentifier)aSN1Primitive, messageImprint, new ASN1Integer(bigInteger), new ASN1GeneralizedTime(date), accuracy, (ASN1Boolean)aSN1Primitive2, aSN1Integer, this.tsa, timeStampRequest.getExtensions());
        try {
            Encodable encodable2;
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            if (timeStampRequest.getCertReq()) {
                cMSSignedDataGenerator.addCertificates(new CollectionStore(this.certs));
                cMSSignedDataGenerator.addAttributeCertificates(new CollectionStore(this.attrCerts));
            }
            cMSSignedDataGenerator.addCRLs(new CollectionStore(this.crls));
            if (!this.otherRevoc.isEmpty()) {
                for (Encodable encodable2 : this.otherRevoc.keySet()) {
                    cMSSignedDataGenerator.addOtherRevocationInfo((ASN1ObjectIdentifier)encodable2, new CollectionStore((Collection)this.otherRevoc.get(encodable2)));
                }
            }
            cMSSignedDataGenerator.addSignerInfoGenerator(this.signerInfoGen);
            Object object = tSTInfo.getEncoded("DER");
            encodable2 = cMSSignedDataGenerator.generate(new CMSProcessableByteArray(PKCSObjectIdentifiers.id_ct_TSTInfo, (byte[])object), true);
            return new TimeStampToken((CMSSignedData)encodable2);
        }
        catch (CMSException cMSException) {
            throw new TSPException("Error generating time-stamp token", cMSException);
        }
        catch (IOException iOException) {
            throw new TSPException("Exception encoding info", iOException);
        }
    }
}

