/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.google.common.base.MoreObjects;

public class TestcontainersConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TestcontainersConfiguration.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private String ambassadorContainerImage = "richnorth/ambassador:latest";
    private String vncRecordedContainerImage = "richnorth/vnc-recorder:latest";
    private String tinyImage = "alpine:3.2";

    private static TestcontainersConfiguration loadConfiguration() {
        TestcontainersConfiguration config = new TestcontainersConfiguration();
        ClassLoader loader = MoreObjects.firstNonNull(Thread.currentThread().getContextClassLoader(), TestcontainersConfiguration.class.getClassLoader());
        URL configOverrides = loader.getResource("testcontainers.properties");
        if (configOverrides != null) {
            log.debug("Testcontainers configuration overrides will be loaded from {}", (Object)configOverrides);
            Properties properties = new Properties();
            try (InputStream inputStream = configOverrides.openStream();){
                properties.load(inputStream);
                config.ambassadorContainerImage = properties.getProperty("ambassador.container.image", config.ambassadorContainerImage);
                config.vncRecordedContainerImage = properties.getProperty("vncrecorder.container.image", config.vncRecordedContainerImage);
                config.tinyImage = properties.getProperty("tinyimage.container.image", config.tinyImage);
                log.debug("Testcontainers configuration overrides loaded from {}: {}", (Object)configOverrides, (Object)config);
            }
            catch (IOException e) {
                log.error("Testcontainers config override was found on classpath but could not be loaded", e);
            }
        }
        return config;
    }

    public String getAmbassadorContainerImage() {
        return this.ambassadorContainerImage;
    }

    public String getVncRecordedContainerImage() {
        return this.vncRecordedContainerImage;
    }

    public String getTinyImage() {
        return this.tinyImage;
    }

    public void setAmbassadorContainerImage(String ambassadorContainerImage) {
        this.ambassadorContainerImage = ambassadorContainerImage;
    }

    public void setVncRecordedContainerImage(String vncRecordedContainerImage) {
        this.vncRecordedContainerImage = vncRecordedContainerImage;
    }

    public void setTinyImage(String tinyImage) {
        this.tinyImage = tinyImage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestcontainersConfiguration)) {
            return false;
        }
        TestcontainersConfiguration other = (TestcontainersConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ambassadorContainerImage = this.getAmbassadorContainerImage();
        String other$ambassadorContainerImage = other.getAmbassadorContainerImage();
        if (this$ambassadorContainerImage == null ? other$ambassadorContainerImage != null : !this$ambassadorContainerImage.equals(other$ambassadorContainerImage)) {
            return false;
        }
        String this$vncRecordedContainerImage = this.getVncRecordedContainerImage();
        String other$vncRecordedContainerImage = other.getVncRecordedContainerImage();
        if (this$vncRecordedContainerImage == null ? other$vncRecordedContainerImage != null : !this$vncRecordedContainerImage.equals(other$vncRecordedContainerImage)) {
            return false;
        }
        String this$tinyImage = this.getTinyImage();
        String other$tinyImage = other.getTinyImage();
        return !(this$tinyImage == null ? other$tinyImage != null : !this$tinyImage.equals(other$tinyImage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestcontainersConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ambassadorContainerImage = this.getAmbassadorContainerImage();
        result = result * 59 + ($ambassadorContainerImage == null ? 43 : $ambassadorContainerImage.hashCode());
        String $vncRecordedContainerImage = this.getVncRecordedContainerImage();
        result = result * 59 + ($vncRecordedContainerImage == null ? 43 : $vncRecordedContainerImage.hashCode());
        String $tinyImage = this.getTinyImage();
        result = result * 59 + ($tinyImage == null ? 43 : $tinyImage.hashCode());
        return result;
    }

    public String toString() {
        return "TestcontainersConfiguration(ambassadorContainerImage=" + this.getAmbassadorContainerImage() + ", vncRecordedContainerImage=" + this.getVncRecordedContainerImage() + ", tinyImage=" + this.getTinyImage() + ")";
    }

    private TestcontainersConfiguration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestcontainersConfiguration getInstance() {
        Object value = instance.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                value = instance.get();
                if (value == null) {
                    TestcontainersConfiguration actualValue = TestcontainersConfiguration.loadConfiguration();
                    value = actualValue == null ? instance : actualValue;
                    instance.set(value);
                }
            }
        }
        return (TestcontainersConfiguration)(value == instance ? null : value);
    }
}

