// Generated by delombok at Sat Dec 29 14:16:25 UTC 2018
package org.testcontainers.jdbc;

import org.testcontainers.exception.ConnectionCreationException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * Containerless jdbc database delegate
 *
 * Is used only with deprecated ScriptUtils
 *
 * @see org.testcontainers.ext.ScriptUtils
 */
public class ContainerLessJdbcDelegate extends JdbcDatabaseDelegate {
    @java.lang.SuppressWarnings("all")
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(ContainerLessJdbcDelegate.class);
    private Connection connection;

    public ContainerLessJdbcDelegate(Connection connection) {
        super(null, "");
        this.connection = connection;
    }

    @Override
    protected Statement createNewConnection() {
        try {
            return connection.createStatement();
        } catch (SQLException e) {
            log.error("Could create JDBC statement");
            throw new ConnectionCreationException("Could create JDBC statement", e);
        }
    }
}
