/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.Links;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ContainerNetwork
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="IPAMConfig")
    private Ipam ipamConfig;
    @JsonProperty(value="Links")
    private Links links;
    @JsonProperty(value="Aliases")
    private List<String> aliases;
    @JsonProperty(value="NetworkID")
    private String networkID;
    @JsonProperty(value="EndpointID")
    private String endpointId;
    @JsonProperty(value="Gateway")
    private String gateway;
    @JsonProperty(value="IPAddress")
    private String ipAddress;
    @JsonProperty(value="IPPrefixLen")
    private Integer ipPrefixLen;
    @JsonProperty(value="IPv6Gateway")
    private String ipV6Gateway;
    @JsonProperty(value="GlobalIPv6Address")
    private String globalIPv6Address;
    @JsonProperty(value="GlobalIPv6PrefixLen")
    private Integer globalIPv6PrefixLen;
    @JsonProperty(value="MacAddress")
    private String macAddress;

    @CheckForNull
    public List<String> getAliases() {
        return this.aliases;
    }

    public ContainerNetwork withAliases(List<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public ContainerNetwork withAliases(String ... aliases) {
        this.aliases = Arrays.asList(aliases);
        return this;
    }

    @CheckForNull
    public String getEndpointId() {
        return this.endpointId;
    }

    public ContainerNetwork withEndpointId(String endpointId) {
        this.endpointId = endpointId;
        return this;
    }

    @CheckForNull
    public String getGateway() {
        return this.gateway;
    }

    public ContainerNetwork withGateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @CheckForNull
    public String getGlobalIPv6Address() {
        return this.globalIPv6Address;
    }

    public ContainerNetwork withGlobalIPv6Address(String globalIPv6Address) {
        this.globalIPv6Address = globalIPv6Address;
        return this;
    }

    @CheckForNull
    public Integer getGlobalIPv6PrefixLen() {
        return this.globalIPv6PrefixLen;
    }

    public ContainerNetwork withGlobalIPv6PrefixLen(Integer globalIPv6PrefixLen) {
        this.globalIPv6PrefixLen = globalIPv6PrefixLen;
        return this;
    }

    @CheckForNull
    public String getIpAddress() {
        return this.ipAddress;
    }

    public ContainerNetwork withIpv4Address(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @CheckForNull
    public Ipam getIpamConfig() {
        return this.ipamConfig;
    }

    public ContainerNetwork withIpamConfig(Ipam ipamConfig) {
        this.ipamConfig = ipamConfig;
        return this;
    }

    @CheckForNull
    public Integer getIpPrefixLen() {
        return this.ipPrefixLen;
    }

    public ContainerNetwork withIpPrefixLen(Integer ipPrefixLen) {
        this.ipPrefixLen = ipPrefixLen;
        return this;
    }

    @CheckForNull
    public String getIpV6Gateway() {
        return this.ipV6Gateway;
    }

    public ContainerNetwork withIpV6Gateway(String ipV6Gateway) {
        this.ipV6Gateway = ipV6Gateway;
        return this;
    }

    @CheckForNull
    @JsonIgnore
    public Link[] getLinks() {
        return this.links == null ? new Link[]{} : this.links.getLinks();
    }

    public ContainerNetwork withLinks(List<Link> links) {
        this.links = new Links(links);
        return this;
    }

    public ContainerNetwork withLinks(Link ... links) {
        this.links = new Links(links);
        return this;
    }

    @CheckForNull
    public String getMacAddress() {
        return this.macAddress;
    }

    public ContainerNetwork withMacAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    @CheckForNull
    public String getNetworkID() {
        return this.networkID;
    }

    public ContainerNetwork withNetworkID(String networkID) {
        this.networkID = networkID;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals(this, o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public static class Ipam {
        @JsonProperty(value="IPv4Address")
        private String ipv4Address;
        @JsonProperty(value="IPv6Address")
        private String ipv6Address;

        public String getIpv4Address() {
            return this.ipv4Address;
        }

        public String getIpv6Address() {
            return this.ipv6Address;
        }

        public Ipam withIpv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
            return this;
        }

        public Ipam withIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }
    }
}

