/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.jdbc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConnectionUrl {
    private String url;
    private String databaseType;
    private Optional<String> imageTag;
    private String dbHostString;
    private boolean inDaemonMode = false;
    private Optional<String> databaseHost = Optional.empty();
    private Optional<Integer> databasePort = Optional.empty();
    private Optional<String> databaseName = Optional.empty();
    private Optional<String> initScriptPath = Optional.empty();
    private boolean reusable = false;
    private Optional<InitFunctionDef> initFunction = Optional.empty();
    private Optional<String> queryString;
    private Map<String, String> containerParameters;
    private Map<String, String> queryParameters;
    private Map<String, String> tmpfsOptions = new HashMap<String, String>();

    public static ConnectionUrl newInstance(String url) {
        ConnectionUrl connectionUrl = new ConnectionUrl(url);
        connectionUrl.parseUrl();
        return connectionUrl;
    }

    private ConnectionUrl(String url) {
        this.url = Objects.requireNonNull(url, "Connection URL cannot be null");
    }

    public static boolean accepts(String url) {
        return url.startsWith("jdbc:tc:");
    }

    private void parseUrl() {
        Matcher daemonMatcher;
        Matcher urlMatcher = Patterns.URL_MATCHING_PATTERN.matcher(this.getUrl());
        if (!urlMatcher.matches() && !(urlMatcher = Patterns.ORACLE_URL_MATCHING_PATTERN.matcher(this.getUrl())).matches()) {
            throw new IllegalArgumentException("JDBC URL matches jdbc:tc: prefix but the database or tag name could not be identified");
        }
        this.databaseType = urlMatcher.group("databaseType");
        this.imageTag = Optional.ofNullable(urlMatcher.group("imageTag"));
        this.dbHostString = urlMatcher.group("dbHostString");
        Matcher dbInstanceMatcher = Patterns.DB_INSTANCE_MATCHING_PATTERN.matcher(this.dbHostString);
        if (dbInstanceMatcher.matches()) {
            this.databaseHost = Optional.of(dbInstanceMatcher.group("databaseHost"));
            this.databasePort = Optional.ofNullable(dbInstanceMatcher.group("databasePort")).map(Integer::valueOf);
            this.databaseName = Optional.of(dbInstanceMatcher.group("databaseName"));
        }
        this.queryParameters = Collections.unmodifiableMap(this.parseQueryParameters(Optional.ofNullable(urlMatcher.group("queryParameters")).orElse("")));
        String query = this.queryParameters.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
        this.queryString = query.trim().length() == 0 ? Optional.empty() : Optional.of("?" + query);
        this.containerParameters = Collections.unmodifiableMap(this.parseContainerParameters());
        this.tmpfsOptions = this.parseTmpfsOptions(this.containerParameters);
        this.initScriptPath = Optional.ofNullable(this.containerParameters.get("TC_INITSCRIPT"));
        this.reusable = Boolean.parseBoolean(this.containerParameters.get("TC_REUSABLE"));
        Matcher funcMatcher = Patterns.INITFUNCTION_MATCHING_PATTERN.matcher(this.getUrl());
        if (funcMatcher.matches()) {
            this.initFunction = Optional.of(new InitFunctionDef(funcMatcher.group(2), funcMatcher.group(4)));
        }
        this.inDaemonMode = (daemonMatcher = Patterns.DAEMON_MATCHING_PATTERN.matcher(this.getUrl())).matches() && Boolean.parseBoolean(daemonMatcher.group(2));
    }

    private Map<String, String> parseTmpfsOptions(Map<String, String> containerParameters) {
        if (!containerParameters.containsKey("TC_TMPFS")) {
            return Collections.emptyMap();
        }
        String tmpfsOptions = containerParameters.get("TC_TMPFS");
        return Stream.of(tmpfsOptions.split(",")).collect(Collectors.toMap(string -> string.split(":")[0], string -> string.split(":")[1]));
    }

    private Map<String, String> parseContainerParameters() {
        HashMap<String, String> results = new HashMap<String, String>();
        Matcher matcher = Patterns.TC_PARAM_MATCHING_PATTERN.matcher(this.getUrl());
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            results.put(key, value);
        }
        return results;
    }

    private Map<String, String> parseQueryParameters(String queryString) {
        HashMap<String, String> results = new HashMap<String, String>();
        Matcher matcher = Patterns.QUERY_PARAM_MATCHING_PATTERN.matcher(queryString);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            if (key.matches("(TC_[A-Z_]+)")) continue;
            results.put(key, value);
        }
        return results;
    }

    public Map<String, String> getTmpfsOptions() {
        return Collections.unmodifiableMap(this.tmpfsOptions);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionUrl)) {
            return false;
        }
        ConnectionUrl other = (ConnectionUrl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConnectionUrl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public Optional<String> getImageTag() {
        return this.imageTag;
    }

    public String getDbHostString() {
        return this.dbHostString;
    }

    public boolean isInDaemonMode() {
        return this.inDaemonMode;
    }

    public Optional<String> getDatabaseHost() {
        return this.databaseHost;
    }

    public Optional<Integer> getDatabasePort() {
        return this.databasePort;
    }

    public Optional<String> getDatabaseName() {
        return this.databaseName;
    }

    public Optional<String> getInitScriptPath() {
        return this.initScriptPath;
    }

    public boolean isReusable() {
        return this.reusable;
    }

    public Optional<InitFunctionDef> getInitFunction() {
        return this.initFunction;
    }

    public Optional<String> getQueryString() {
        return this.queryString;
    }

    public Map<String, String> getContainerParameters() {
        return this.containerParameters;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public static interface Patterns {
        public static final Pattern URL_MATCHING_PATTERN = Pattern.compile("jdbc:tc:(?<databaseType>[a-z0-9]+)(:(?<imageTag>[^:]+))?://(?<dbHostString>[^?]+)(?<queryParameters>\\?.*)?");
        public static final Pattern ORACLE_URL_MATCHING_PATTERN = Pattern.compile("jdbc:tc:(?<databaseType>[a-z]+)(:(?<imageTag>(?!thin).+))?:thin:(//)?((?<username>[^:?^/]+)/(?<password>[^?^/]+))?@(?<dbHostString>[^?]+)(?<queryParameters>\\?.*)?");
        public static final Pattern DB_INSTANCE_MATCHING_PATTERN = Pattern.compile("(?<databaseHost>[^:]+)(:(?<databasePort>[0-9]+))?((?<sidOrServiceName>[:/])|;databaseName=)(?<databaseName>[^\\\\?]+)");
        public static final Pattern DAEMON_MATCHING_PATTERN = Pattern.compile(".*([?&]?)TC_DAEMON=([^?&]+).*");
        @Deprecated
        public static final Pattern INITSCRIPT_MATCHING_PATTERN = Pattern.compile(".*([?&]?)TC_INITSCRIPT=([^?&]+).*");
        public static final Pattern INITFUNCTION_MATCHING_PATTERN = Pattern.compile(".*([?&]?)TC_INITFUNCTION=((\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)::(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*).*");
        public static final String TC_PARAM_NAME_PATTERN = "(TC_[A-Z_]+)";
        public static final Pattern TC_PARAM_MATCHING_PATTERN = Pattern.compile("(TC_[A-Z_]+)=([^?&]+)");
        public static final Pattern QUERY_PARAM_MATCHING_PATTERN = Pattern.compile("([^?&=]+)=([^?&]*)");
    }

    public class InitFunctionDef {
        private String className;
        private String methodName;

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public InitFunctionDef(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }
    }
}

