/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.rnorth.ducttape.ratelimits.RateLimiter;
import org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.traits.LinkableContainer;
import org.testcontainers.utility.MountableFile;

public abstract class JdbcDatabaseContainer<SELF extends JdbcDatabaseContainer<SELF>>
extends GenericContainer<SELF>
implements LinkableContainer {
    private static final Object DRIVER_LOAD_MUTEX = new Object();
    private Driver driver;
    protected Map<String, String> parameters = new HashMap<String, String>();
    private static final RateLimiter DB_CONNECT_RATE_LIMIT = RateLimiterBuilder.newBuilder().withRate(10, TimeUnit.SECONDS).withConstantThroughput().build();

    public JdbcDatabaseContainer(String dockerImageName) {
        super(dockerImageName);
    }

    protected abstract String getDriverClassName();

    public abstract String getJdbcUrl();

    public abstract String getUsername();

    public abstract String getPassword();

    protected abstract String getTestQueryString();

    protected void waitUntilContainerStarted() {
        this.logger().info("Waiting for database connection to become available at {} using query '{}'", (Object)this.getJdbcUrl(), (Object)this.getTestQueryString());
        Unreliables.retryUntilSuccess((int)120, (TimeUnit)TimeUnit.SECONDS, () -> {
            if (!this.isRunning().booleanValue()) {
                throw new ContainerLaunchException("Container failed to start");
            }
            Throwable throwable = null;
            try (Connection connection = (Connection)DB_CONNECT_RATE_LIMIT.getWhenReady(() -> this.createConnection(""));){
                boolean success = connection.createStatement().execute(this.getTestQueryString());
                if (success) {
                    this.logger().info("Obtained a connection to container ({})", (Object)this.getJdbcUrl());
                    Object var4_5 = null;
                    return var4_5;
                }
                try {
                    throw new SQLException("Failed to execute test query");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Driver getJdbcDriverInstance() {
        Object object = DRIVER_LOAD_MUTEX;
        synchronized (object) {
            if (this.driver == null) {
                try {
                    this.driver = (Driver)Class.forName(this.getDriverClassName()).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Could not get Driver", e);
                }
            }
        }
        return this.driver;
    }

    public Connection createConnection(String queryString) throws SQLException {
        Properties info = new Properties();
        info.put("user", this.getUsername());
        info.put("password", this.getPassword());
        String url = this.getJdbcUrl() + queryString;
        Driver jdbcDriverInstance = this.getJdbcDriverInstance();
        try {
            return (Connection)Unreliables.retryUntilSuccess((int)120, (TimeUnit)TimeUnit.SECONDS, () -> jdbcDriverInstance.connect(url, info));
        }
        catch (Exception e) {
            throw new SQLException("Could not create new connection", e);
        }
    }

    protected void optionallyMapResourceParameterAsVolume(@NotNull String paramName, @NotNull String pathNameInContainer, @NotNull String defaultResource) {
        String resourceName = this.parameters.getOrDefault(paramName, defaultResource);
        if (resourceName != null) {
            MountableFile mountableFile = MountableFile.forClasspathResource((String)resourceName);
            this.addFileSystemBind(mountableFile.getResolvedPath(), pathNameInContainer, BindMode.READ_ONLY);
        }
    }

    protected abstract Integer getLivenessCheckPort();

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String paramName, String value) {
        this.parameters.put(paramName, value);
    }
}

