/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.jdbc;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.JdbcDatabaseContainerProvider;
import org.testcontainers.jdbc.ConnectionWrapper;
import org.testcontainers.jdbc.ext.ScriptUtils;

public class ContainerDatabaseDriver
implements Driver {
    private static final Pattern URL_MATCHING_PATTERN = Pattern.compile("jdbc:tc:([a-z]+)(:([^:]+))?://[^\\?]+(\\?.*)?");
    private static final Pattern DAEMON_MATCHING_PATTERN = Pattern.compile(".*([\\?&]?)TC_DAEMON=([^\\?&]+).*");
    private static final Pattern INITSCRIPT_MATCHING_PATTERN = Pattern.compile(".*([\\?&]?)TC_INITSCRIPT=([^\\?&]+).*");
    private static final Pattern INITFUNCTION_MATCHING_PATTERN = Pattern.compile(".*([\\?&]?)TC_INITFUNCTION=((\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)::(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*).*");
    private static final Pattern TC_PARAM_MATCHING_PATTERN = Pattern.compile("([A-Z_]+)=([^\\?&]+)");
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerDatabaseDriver.class);
    private Driver delegate;
    private static final Map<String, Set<Connection>> containerConnections = new HashMap<String, Set<Connection>>();
    private static final Map<String, JdbcDatabaseContainer> jdbcUrlContainerCache = new HashMap<String, JdbcDatabaseContainer>();
    private static final Set<String> initializedContainers = new HashSet<String>();

    private static void load() {
        try {
            DriverManager.registerDriver(new ContainerDatabaseDriver());
        }
        catch (SQLException e) {
            LOGGER.warn("Failed to register driver", (Throwable)e);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:tc:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        Map<String, JdbcDatabaseContainer> map = jdbcUrlContainerCache;
        synchronized (map) {
            String queryString = "";
            JdbcDatabaseContainer container = jdbcUrlContainerCache.get(url);
            if (container == null) {
                Matcher urlMatcher = URL_MATCHING_PATTERN.matcher(url);
                if (!urlMatcher.matches()) {
                    throw new IllegalArgumentException("JDBC URL matches jdbc:tc: prefix but the database or tag name could not be identified");
                }
                String databaseType = urlMatcher.group(1);
                String tag = urlMatcher.group(3);
                if (tag == null) {
                    tag = "latest";
                }
                if ((queryString = urlMatcher.group(4)) == null) {
                    queryString = "";
                }
                Map<String, String> parameters = this.getContainerParameters(url);
                ServiceLoader<JdbcDatabaseContainerProvider> databaseContainers = ServiceLoader.load(JdbcDatabaseContainerProvider.class);
                for (JdbcDatabaseContainerProvider candidateContainerType : databaseContainers) {
                    if (!candidateContainerType.supports(databaseType)) continue;
                    container = candidateContainerType.newInstance(tag);
                    this.delegate = container.getJdbcDriverInstance();
                }
                if (container == null) {
                    throw new UnsupportedOperationException("Database name " + databaseType + " not supported");
                }
                jdbcUrlContainerCache.put(url, container);
                container.setParameters(parameters);
                container.start();
            }
            Connection connection = container.createConnection(queryString);
            if (!initializedContainers.contains(container.getContainerId())) {
                this.runInitScriptIfRequired(url, connection);
                this.runInitFunctionIfRequired(url, connection);
                initializedContainers.add(container.getContainerId());
            }
            return this.wrapConnection(connection, container, url);
        }
    }

    private Map<String, String> getContainerParameters(String url) {
        HashMap<String, String> results = new HashMap<String, String>();
        Matcher matcher = TC_PARAM_MATCHING_PATTERN.matcher(url);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            results.put(key, value);
        }
        return results;
    }

    private Connection wrapConnection(Connection connection, JdbcDatabaseContainer container, String url) {
        Matcher matcher = DAEMON_MATCHING_PATTERN.matcher(url);
        boolean isDaemon = matcher.matches() ? Boolean.parseBoolean(matcher.group(2)) : false;
        Set<Connection> connections = containerConnections.get(container.getContainerId());
        if (connections == null) {
            connections = new HashSet<Connection>();
            containerConnections.put(container.getContainerId(), connections);
        }
        connections.add(connection);
        Set<Connection> finalConnections = connections;
        return new ConnectionWrapper(connection, () -> {
            finalConnections.remove(connection);
            if (!isDaemon && finalConnections.isEmpty()) {
                container.stop();
                jdbcUrlContainerCache.remove(url);
            }
        });
    }

    private void runInitScriptIfRequired(String url, Connection connection) throws SQLException {
        Matcher matcher = INITSCRIPT_MATCHING_PATTERN.matcher(url);
        if (matcher.matches()) {
            String initScriptPath = matcher.group(2);
            try {
                URL resource = Thread.currentThread().getContextClassLoader().getResource(initScriptPath);
                if (resource == null) {
                    LOGGER.warn("Could not load classpath init script: {}", (Object)initScriptPath);
                    throw new SQLException("Could not load classpath init script: " + initScriptPath + ". Resource not found.");
                }
                String sql = IOUtils.toString((URL)resource, (Charset)StandardCharsets.UTF_8);
                ScriptUtils.executeSqlScript(connection, initScriptPath, sql);
            }
            catch (IOException e) {
                LOGGER.warn("Could not load classpath init script: {}", (Object)initScriptPath);
                throw new SQLException("Could not load classpath init script: " + initScriptPath, e);
            }
            catch (ScriptException e) {
                LOGGER.error("Error while executing init script: {}", (Object)initScriptPath, (Object)e);
                throw new SQLException("Error while executing init script: " + initScriptPath, e);
            }
        }
    }

    private void runInitFunctionIfRequired(String url, Connection connection) throws SQLException {
        Matcher matcher = INITFUNCTION_MATCHING_PATTERN.matcher(url);
        if (matcher.matches()) {
            String className = matcher.group(2);
            String methodName = matcher.group(4);
            try {
                Class<?> initFunctionClazz = Class.forName(className);
                Method method = initFunctionClazz.getMethod(methodName, Connection.class);
                method.invoke(null, connection);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Error while executing init function: {}::{}", new Object[]{className, methodName, e});
                throw new SQLException("Error while executing init function: " + className + "::" + methodName, e);
            }
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.delegate.getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return this.delegate.jdbcCompliant();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killContainers() {
        Map<String, JdbcDatabaseContainer> map = jdbcUrlContainerCache;
        synchronized (map) {
            jdbcUrlContainerCache.values().forEach(GenericContainer::stop);
            jdbcUrlContainerCache.clear();
            containerConnections.clear();
            initializedContainers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killContainer(String jdbcUrl) {
        Map<String, JdbcDatabaseContainer> map = jdbcUrlContainerCache;
        synchronized (map) {
            JdbcDatabaseContainer container = jdbcUrlContainerCache.get(jdbcUrl);
            if (container != null) {
                container.stop();
                jdbcUrlContainerCache.remove(jdbcUrl);
                containerConnections.remove(container.getContainerId());
                initializedContainers.remove(container.getContainerId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JdbcDatabaseContainer getContainer(String jdbcUrl) {
        Map<String, JdbcDatabaseContainer> map = jdbcUrlContainerCache;
        synchronized (map) {
            return jdbcUrlContainerCache.get(jdbcUrl);
        }
    }

    static {
        ContainerDatabaseDriver.load();
    }
}

