/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.junit.jupiter;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.lifecycle.Startable;

class TestcontainersExtension
implements BeforeEachCallback,
BeforeAllCallback,
TestInstancePostProcessor {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{TestcontainersExtension.class});
    private static final String TEST_INSTANCE = "testInstance";

    TestcontainersExtension() {
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        store.put((Object)TEST_INSTANCE, testInstance);
    }

    public void beforeAll(ExtensionContext context) {
        Class testClass = (Class)context.getTestClass().orElseThrow(() -> new ExtensionConfigurationException("TestcontainersExtension is only supported for classes."));
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        this.findSharedContainers(testClass).forEach(adapter -> store.getOrComputeIfAbsent((Object)adapter.getKey(), k -> ((StoreAdapter)adapter).start()));
    }

    public void beforeEach(ExtensionContext context) {
        this.collectParentTestInstances(context).parallelStream().flatMap(this::findRestartContainers).forEach(adapter -> context.getStore(NAMESPACE).getOrComputeIfAbsent((Object)adapter.getKey(), k -> ((StoreAdapter)adapter).start()));
    }

    private Set<Object> collectParentTestInstances(ExtensionContext context) {
        LinkedHashSet<Object> testInstances = new LinkedHashSet<Object>();
        Optional current = Optional.of(context);
        while (current.isPresent()) {
            ExtensionContext ctx = current.get();
            Object testInstance = ctx.getStore(NAMESPACE).remove((Object)TEST_INSTANCE);
            if (testInstance != null) {
                testInstances.add(testInstance);
            }
            current = ctx.getParent();
        }
        return testInstances;
    }

    private Stream<StoreAdapter> findSharedContainers(Class<?> testClass) {
        return ReflectionUtils.findFields(testClass, this.isSharedContainer(), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).stream().map(f -> TestcontainersExtension.getContainerInstance(null, f));
    }

    private Predicate<Field> isSharedContainer() {
        return TestcontainersExtension.isContainer().and(ReflectionUtils::isStatic);
    }

    private Stream<StoreAdapter> findRestartContainers(Object testInstance) {
        return ReflectionUtils.findFields(testInstance.getClass(), this.isRestartContainer(), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).stream().map(f -> TestcontainersExtension.getContainerInstance(testInstance, f));
    }

    private Predicate<Field> isRestartContainer() {
        return TestcontainersExtension.isContainer().and(ReflectionUtils::isNotStatic);
    }

    private static Predicate<Field> isContainer() {
        return field -> {
            boolean isAnnotatedWithContainer = AnnotationSupport.isAnnotated((AnnotatedElement)field, Container.class);
            if (isAnnotatedWithContainer) {
                boolean isStartable = Startable.class.isAssignableFrom(field.getType());
                if (!isStartable) {
                    throw new ExtensionConfigurationException("Annotation is only supported for Startable types");
                }
                return true;
            }
            return false;
        };
    }

    private static StoreAdapter getContainerInstance(Object testInstance, Field field) {
        try {
            field.setAccessible(true);
            Startable containerInstance = (Startable)Preconditions.notNull((Object)((Startable)field.get(testInstance)), (String)("Container " + field.getName() + " needs to be initialized"));
            return new StoreAdapter(field.getDeclaringClass(), field.getName(), containerInstance);
        }
        catch (IllegalAccessException e) {
            throw new ExtensionConfigurationException("Can not access container defined in field " + field.getName());
        }
    }

    private static class StoreAdapter
    implements ExtensionContext.Store.CloseableResource {
        private String key;
        private Startable container;

        private StoreAdapter(Class<?> declaringClass, String fieldName, Startable container) {
            this.key = declaringClass.getName() + "." + fieldName;
            this.container = container;
        }

        private StoreAdapter start() {
            this.container.start();
            return this;
        }

        public void close() {
            this.container.stop();
        }

        public String getKey() {
            return this.key;
        }
    }
}

