/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.junit.jupiter;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.FilesystemFriendlyNameGenerator;
import org.testcontainers.junit.jupiter.Testcontainers;
import org.testcontainers.junit.jupiter.TestcontainersTestDescription;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.lifecycle.TestDescription;
import org.testcontainers.lifecycle.TestLifecycleAware;

class TestcontainersExtension
implements BeforeEachCallback,
BeforeAllCallback,
AfterEachCallback,
AfterAllCallback,
ExecutionCondition,
TestInstancePostProcessor {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{TestcontainersExtension.class});
    private static final String TEST_INSTANCE = "testInstance";
    private static final String SHARED_LIFECYCLE_AWARE_CONTAINERS = "sharedLifecycleAwareContainers";
    private static final String LOCAL_LIFECYCLE_AWARE_CONTAINERS = "localLifecycleAwareContainers";

    TestcontainersExtension() {
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        store.put((Object)TEST_INSTANCE, testInstance);
    }

    public void beforeAll(ExtensionContext context) {
        Class testClass = (Class)context.getTestClass().orElseThrow(() -> new ExtensionConfigurationException("TestcontainersExtension is only supported for classes."));
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        List<StoreAdapter> sharedContainersStoreAdapters = this.findSharedContainers(testClass);
        sharedContainersStoreAdapters.forEach(adapter -> store.getOrComputeIfAbsent((Object)adapter.getKey(), k -> ((StoreAdapter)adapter).start()));
        List<TestLifecycleAware> lifecycleAwareContainers = sharedContainersStoreAdapters.stream().filter(this::isTestLifecycleAware).map(lifecycleAwareAdapter -> (TestLifecycleAware)((StoreAdapter)lifecycleAwareAdapter).container).collect(Collectors.toList());
        store.put((Object)SHARED_LIFECYCLE_AWARE_CONTAINERS, lifecycleAwareContainers);
        this.signalBeforeTestToContainers(lifecycleAwareContainers, this.testDescriptionFrom(context));
    }

    public void afterAll(ExtensionContext context) {
        this.signalAfterTestToContainersFor(SHARED_LIFECYCLE_AWARE_CONTAINERS, context);
    }

    public void beforeEach(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        List<TestLifecycleAware> lifecycleAwareContainers = this.collectParentTestInstances(context).parallelStream().flatMap(this::findRestartContainers).peek(adapter -> store.getOrComputeIfAbsent((Object)adapter.getKey(), k -> ((StoreAdapter)adapter).start())).filter(this::isTestLifecycleAware).map(lifecycleAwareAdapter -> (TestLifecycleAware)((StoreAdapter)lifecycleAwareAdapter).container).collect(Collectors.toList());
        store.put((Object)LOCAL_LIFECYCLE_AWARE_CONTAINERS, lifecycleAwareContainers);
        this.signalBeforeTestToContainers(lifecycleAwareContainers, this.testDescriptionFrom(context));
    }

    public void afterEach(ExtensionContext context) {
        this.signalAfterTestToContainersFor(LOCAL_LIFECYCLE_AWARE_CONTAINERS, context);
    }

    private void signalBeforeTestToContainers(List<TestLifecycleAware> lifecycleAwareContainers, TestDescription testDescription) {
        lifecycleAwareContainers.forEach(container -> container.beforeTest(testDescription));
    }

    private void signalAfterTestToContainersFor(String storeKey, ExtensionContext context) {
        List lifecycleAwareContainers = (List)context.getStore(NAMESPACE).get((Object)storeKey);
        if (lifecycleAwareContainers != null) {
            TestDescription description = this.testDescriptionFrom(context);
            Optional throwable = context.getExecutionException();
            lifecycleAwareContainers.forEach(container -> container.afterTest(description, throwable));
        }
    }

    private TestDescription testDescriptionFrom(ExtensionContext context) {
        return new TestcontainersTestDescription(context.getUniqueId(), FilesystemFriendlyNameGenerator.filesystemFriendlyNameOf(context));
    }

    private boolean isTestLifecycleAware(StoreAdapter adapter) {
        return adapter.container instanceof TestLifecycleAware;
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return this.findTestcontainers(context).map(this::evaluate).orElseThrow(() -> new ExtensionConfigurationException("@Testcontainers not found"));
    }

    private Optional<Testcontainers> findTestcontainers(ExtensionContext context) {
        Optional current = Optional.of(context);
        while (current.isPresent()) {
            Optional testcontainers = AnnotationUtils.findAnnotation((AnnotatedElement)current.get().getRequiredTestClass(), Testcontainers.class);
            if (testcontainers.isPresent()) {
                return testcontainers;
            }
            current = current.get().getParent();
        }
        return Optional.empty();
    }

    private ConditionEvaluationResult evaluate(Testcontainers testcontainers) {
        if (testcontainers.disabledWithoutDocker()) {
            if (this.isDockerAvailable()) {
                return ConditionEvaluationResult.enabled((String)"Docker is available");
            }
            return ConditionEvaluationResult.disabled((String)"disabledWithoutDocker is true and Docker is not available");
        }
        return ConditionEvaluationResult.enabled((String)"disabledWithoutDocker is false");
    }

    boolean isDockerAvailable() {
        try {
            DockerClientFactory.instance().client();
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private Set<Object> collectParentTestInstances(ExtensionContext context) {
        LinkedHashSet<Object> testInstances = new LinkedHashSet<Object>();
        Optional current = Optional.of(context);
        while (current.isPresent()) {
            ExtensionContext ctx = current.get();
            Object testInstance = ctx.getStore(NAMESPACE).remove((Object)TEST_INSTANCE);
            if (testInstance != null) {
                testInstances.add(testInstance);
            }
            current = ctx.getParent();
        }
        return testInstances;
    }

    private List<StoreAdapter> findSharedContainers(Class<?> testClass) {
        return ReflectionUtils.findFields(testClass, this.isSharedContainer(), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).stream().map(f -> TestcontainersExtension.getContainerInstance(null, f)).collect(Collectors.toList());
    }

    private Predicate<Field> isSharedContainer() {
        return TestcontainersExtension.isContainer().and(ReflectionUtils::isStatic);
    }

    private Stream<StoreAdapter> findRestartContainers(Object testInstance) {
        return ReflectionUtils.findFields(testInstance.getClass(), this.isRestartContainer(), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).stream().map(f -> TestcontainersExtension.getContainerInstance(testInstance, f));
    }

    private Predicate<Field> isRestartContainer() {
        return TestcontainersExtension.isContainer().and(ReflectionUtils::isNotStatic);
    }

    private static Predicate<Field> isContainer() {
        return field -> {
            boolean isAnnotatedWithContainer = AnnotationSupport.isAnnotated((AnnotatedElement)field, Container.class);
            if (isAnnotatedWithContainer) {
                boolean isStartable = Startable.class.isAssignableFrom(field.getType());
                if (!isStartable) {
                    throw new ExtensionConfigurationException(String.format("FieldName: %s does not implement Startable", field.getName()));
                }
                return true;
            }
            return false;
        };
    }

    private static StoreAdapter getContainerInstance(Object testInstance, Field field) {
        try {
            field.setAccessible(true);
            Startable containerInstance = (Startable)Preconditions.notNull((Object)((Startable)field.get(testInstance)), (String)("Container " + field.getName() + " needs to be initialized"));
            return new StoreAdapter(field.getDeclaringClass(), field.getName(), containerInstance);
        }
        catch (IllegalAccessException e) {
            throw new ExtensionConfigurationException("Can not access container defined in field " + field.getName());
        }
    }

    private static class StoreAdapter
    implements ExtensionContext.Store.CloseableResource {
        private String key;
        private Startable container;

        private StoreAdapter(Class<?> declaringClass, String fieldName, Startable container) {
            this.key = declaringClass.getName() + "." + fieldName;
            this.container = container;
        }

        private StoreAdapter start() {
            this.container.start();
            return this;
        }

        public void close() {
            this.container.stop();
        }

        public String getKey() {
            return this.key;
        }
    }
}

