/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.TestcontainersConfiguration;

public class KafkaContainer
extends GenericContainer<KafkaContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"confluentinc/cp-kafka");
    private static final String DEFAULT_TAG = "5.2.1";
    private static final String STARTER_SCRIPT = "/testcontainers_start.sh";
    public static final int KAFKA_PORT = 9093;
    public static final int ZOOKEEPER_PORT = 2181;
    private static final int PORT_NOT_ASSIGNED = -1;
    protected String externalZookeeperConnect = null;
    private int port = -1;

    @Deprecated
    public KafkaContainer() {
        this(TestcontainersConfiguration.getInstance().getKafkaDockerImageName().withTag(DEFAULT_TAG));
    }

    @Deprecated
    public KafkaContainer(String confluentPlatformVersion) {
        this(TestcontainersConfiguration.getInstance().getKafkaDockerImageName().withTag(confluentPlatformVersion));
    }

    public KafkaContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{9093});
        this.withEnv("KAFKA_LISTENERS", "PLAINTEXT://0.0.0.0:9093,BROKER://0.0.0.0:9092");
        this.withEnv("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", "BROKER:PLAINTEXT,PLAINTEXT:PLAINTEXT");
        this.withEnv("KAFKA_INTER_BROKER_LISTENER_NAME", "BROKER");
        this.withEnv("KAFKA_BROKER_ID", "1");
        this.withEnv("KAFKA_OFFSETS_TOPIC_REPLICATION_FACTOR", "1");
        this.withEnv("KAFKA_OFFSETS_TOPIC_NUM_PARTITIONS", "1");
        this.withEnv("KAFKA_LOG_FLUSH_INTERVAL_MESSAGES", "9223372036854775807");
        this.withEnv("KAFKA_GROUP_INITIAL_REBALANCE_DELAY_MS", "0");
    }

    public KafkaContainer withEmbeddedZookeeper() {
        this.externalZookeeperConnect = null;
        return (KafkaContainer)this.self();
    }

    public KafkaContainer withExternalZookeeper(String connectString) {
        this.externalZookeeperConnect = connectString;
        return (KafkaContainer)this.self();
    }

    public String getBootstrapServers() {
        if (this.port == -1) {
            throw new IllegalStateException("You should start Kafka container first");
        }
        return String.format("PLAINTEXT://%s:%s", this.getHost(), this.port);
    }

    protected void doStart() {
        this.withCommand(new String[]{"sh", "-c", "while [ ! -f /testcontainers_start.sh ]; do sleep 0.1; done; /testcontainers_start.sh"});
        if (this.externalZookeeperConnect == null) {
            this.addExposedPort(2181);
        }
        super.doStart();
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarting(containerInfo, reused);
        this.port = this.getMappedPort(9093);
        if (reused) {
            return;
        }
        String zookeeperConnect = this.externalZookeeperConnect != null ? this.externalZookeeperConnect : this.startZookeeper();
        String command = "#!/bin/bash \n";
        command = command + "export KAFKA_ZOOKEEPER_CONNECT='" + zookeeperConnect + "'\n";
        command = command + "export KAFKA_ADVERTISED_LISTENERS='" + Stream.concat(Stream.of(this.getBootstrapServers()), containerInfo.getNetworkSettings().getNetworks().values().stream().map(it -> "BROKER://" + it.getIpAddress() + ":9092")).collect(Collectors.joining(",")) + "'\n";
        command = command + ". /etc/confluent/docker/bash-config \n";
        command = command + "/etc/confluent/docker/configure \n";
        command = command + "/etc/confluent/docker/launch \n";
        this.copyFileToContainer(Transferable.of((byte[])command.getBytes(StandardCharsets.UTF_8), (int)700), STARTER_SCRIPT);
    }

    private String startZookeeper() {
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(this.getContainerId()).withCmd(new String[]{"sh", "-c", "printf 'clientPort=2181\ndataDir=/var/lib/zookeeper/data\ndataLogDir=/var/lib/zookeeper/log' > /zookeeper.properties\nzookeeper-server-start /zookeeper.properties\n"}).exec();
        this.dockerClient.execStartCmd(execCreateCmdResponse.getId()).start().awaitStarted(10L, TimeUnit.SECONDS);
        return "localhost:2181";
    }
}

