/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.ldap;

import com.github.dockerjava.api.command.InspectContainerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class LLdapContainer
extends GenericContainer<LLdapContainer> {
    private static final Logger log = LoggerFactory.getLogger(LLdapContainer.class);
    private static final String IMAGE_VERSION = "lldap/lldap";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"lldap/lldap");
    private static final int LDAP_PORT = 3890;
    private static final int LDAPS_PORT = 6360;
    private static final int UI_PORT = 17170;

    public LLdapContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public LLdapContainer(DockerImageName image) {
        super(image);
        image.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.addExposedPorts(new int[]{3890, 17170});
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/health").forPort(17170).forStatusCode(200));
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        log.info("LLDAP container is ready! UI available at http://{}:{}", (Object)this.getHost(), (Object)this.getMappedPort(17170));
    }

    public LLdapContainer withBaseDn(String baseDn) {
        this.withEnv("LLDAP_LDAP_BASE_DN", baseDn);
        return this;
    }

    public LLdapContainer withUserPass(String userPass) {
        this.withEnv("LLDAP_LDAP_USER_PASS", userPass);
        return this;
    }

    public int getLdapPort() {
        int port = this.getEnvMap().getOrDefault("LLDAP_LDAPS_OPTIONS__ENABLED", "false").equals("true") ? 6360 : 3890;
        return this.getMappedPort(port);
    }

    public String getLdapUrl() {
        String protocol = this.getEnvMap().getOrDefault("LLDAP_LDAPS_OPTIONS__ENABLED", "false").equals("true") ? "ldaps" : "ldap";
        return String.format("%s://%s:%d", protocol, this.getHost(), this.getLdapPort());
    }

    public String getBaseDn() {
        return this.getEnvMap().getOrDefault("LLDAP_LDAP_BASE_DN", "dc=example,dc=com");
    }

    public String getUser() {
        return String.format("cn=admin,ou=people,%s", this.getBaseDn());
    }

    public String getUserPass() {
        return this.getEnvMap().getOrDefault("LLDAP_LDAP_USER_PASS", "password");
    }
}

