// Generated by delombok at Tue Jul 31 07:41:49 UTC 2018
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import org.mockserver.client.server.MockServerClient;

public class MockServerContainer extends GenericContainer<MockServerContainer> {
    @java.lang.SuppressWarnings("all")
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(MockServerContainer.class);
    public static final String VERSION = "5.3.0";
    public static final int PORT = 80;
    private MockServerClient client;

    public MockServerContainer() {
        this(VERSION);
    }

    public MockServerContainer(String version) {
        super("jamesdbloom/mockserver:mockserver-" + version);
        withCommand("/opt/mockserver/run_mockserver.sh -logLevel INFO -serverPort " + PORT);
        addExposedPorts(PORT);
    }

    @Override
    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        super.containerIsStarted(containerInfo);
        client = new MockServerClient(getContainerIpAddress(), getMappedPort(PORT));
    }

    public String getEndpoint() {
        return String.format("http://%s:%d", getContainerIpAddress(), getMappedPort(PORT));
    }

    @java.lang.SuppressWarnings("all")
    public MockServerClient getClient() {
        return this.client;
    }
}
