/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class MongoDBContainer
extends GenericContainer<MongoDBContainer> {
    private static final Logger log = LoggerFactory.getLogger(MongoDBContainer.class);
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"mongo");
    private static final String DEFAULT_TAG = "4.0.10";
    private static final int CONTAINER_EXIT_CODE_OK = 0;
    private static final int MONGODB_INTERNAL_PORT = 27017;
    private static final int AWAIT_INIT_REPLICA_SET_ATTEMPTS = 60;
    private static final String MONGODB_DATABASE_NAME_DEFAULT = "test";

    @Deprecated
    public MongoDBContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public MongoDBContainer(@NonNull String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
        if (dockerImageName == null) {
            throw new NullPointerException("dockerImageName is marked non-null but is null");
        }
    }

    public MongoDBContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{27017});
        this.withCommand(new String[]{"--replSet", "docker-rs"});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)"(?i).*waiting for connections.*", (int)1));
    }

    public String getConnectionString() {
        return String.format("mongodb://%s:%d", this.getHost(), this.getMappedPort(27017));
    }

    public String getReplicaSetUrl() {
        return this.getReplicaSetUrl(MONGODB_DATABASE_NAME_DEFAULT);
    }

    public String getReplicaSetUrl(String databaseName) {
        if (!this.isRunning()) {
            throw new IllegalStateException("MongoDBContainer should be started first");
        }
        return this.getConnectionString() + "/" + databaseName;
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.initReplicaSet();
    }

    private String[] buildMongoEvalCommand(String command) {
        return new String[]{"mongo", "--eval", command};
    }

    private void checkMongoNodeExitCode(Container.ExecResult execResult) {
        if (execResult.getExitCode() != 0) {
            String errorMessage = String.format("An error occurred: %s", execResult.getStdout());
            log.error(errorMessage);
            throw new ReplicaSetInitializationException(errorMessage);
        }
    }

    private String buildMongoWaitCommand() {
        return String.format("var attempt = 0; while(%s) { if (attempt > %d) {quit(1);} print('%s ' + attempt); sleep(100);  attempt++;  }", "db.runCommand( { isMaster: 1 } ).ismaster==false", 60, "An attempt to await for a single node replica set initialization:");
    }

    private void checkMongoNodeExitCodeAfterWaiting(Container.ExecResult execResultWaitForMaster) {
        if (execResultWaitForMaster.getExitCode() != 0) {
            String errorMessage = String.format("A single node replica set was not initialized in a set timeout: %d attempts", 60);
            log.error(errorMessage);
            throw new ReplicaSetInitializationException(errorMessage);
        }
    }

    private void initReplicaSet() {
        log.debug("Initializing a single node node replica set...");
        Container.ExecResult execResultInitRs = this.execInContainer(this.buildMongoEvalCommand("rs.initiate();"));
        log.debug(execResultInitRs.getStdout());
        this.checkMongoNodeExitCode(execResultInitRs);
        log.debug("Awaiting for a single node replica set initialization up to {} attempts", (Object)60);
        Container.ExecResult execResultWaitForMaster = this.execInContainer(this.buildMongoEvalCommand(this.buildMongoWaitCommand()));
        log.debug(execResultWaitForMaster.getStdout());
        this.checkMongoNodeExitCodeAfterWaiting(execResultWaitForMaster);
    }

    public static class ReplicaSetInitializationException
    extends RuntimeException {
        ReplicaSetInitializationException(String errorMessage) {
            super(errorMessage);
        }
    }
}

