/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.time.Duration;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.ComparableVersion;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.LicenseAcceptance;
import org.testcontainers.utility.MountableFile;

public class Neo4jContainer<S extends Neo4jContainer<S>>
extends GenericContainer<S> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"neo4j");
    private static final String DEFAULT_TAG = "4.4";
    private static final String ENTERPRISE_TAG = "4.4-enterprise";
    private static final int DEFAULT_BOLT_PORT = 7687;
    private static final int DEFAULT_HTTPS_PORT = 7473;
    private static final int DEFAULT_HTTP_PORT = 7474;
    private static final String DEFAULT_ADMIN_PASSWORD = "password";
    private static final String AUTH_FORMAT = "neo4j/%s";
    private final boolean standardImage;
    private String adminPassword = "password";

    @Deprecated
    public Neo4jContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public Neo4jContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public Neo4jContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.standardImage = dockerImageName.getUnversionedPart().equals(DEFAULT_IMAGE_NAME.getUnversionedPart());
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        LogMessageWaitStrategy waitForBolt = new LogMessageWaitStrategy().withRegEx(String.format(".*Bolt enabled on .*:%d\\.\n", 7687));
        HttpWaitStrategy waitForHttp = new HttpWaitStrategy().forPort(7474).forStatusCodeMatching(response -> response == 200);
        this.waitStrategy = new WaitAllStrategy().withStrategy((WaitStrategy)waitForBolt).withStrategy((WaitStrategy)waitForHttp).withStartupTimeout(Duration.ofMinutes(2L));
        this.addExposedPorts(new int[]{7687, 7474, 7473});
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return Stream.of(7687, 7474, 7473).map(arg_0 -> ((Neo4jContainer)this).getMappedPort(arg_0)).collect(Collectors.toSet());
    }

    protected void configure() {
        boolean emptyAdminPassword = this.adminPassword == null || this.adminPassword.isEmpty();
        String neo4jAuth = emptyAdminPassword ? "none" : String.format(AUTH_FORMAT, this.adminPassword);
        this.addEnv("NEO4J_AUTH", neo4jAuth);
    }

    public String getBoltUrl() {
        return String.format("bolt://" + this.getHost() + ":" + this.getMappedPort(7687), new Object[0]);
    }

    public String getHttpUrl() {
        return String.format("http://" + this.getHost() + ":" + this.getMappedPort(7474), new Object[0]);
    }

    public String getHttpsUrl() {
        return String.format("https://" + this.getHost() + ":" + this.getMappedPort(7473), new Object[0]);
    }

    public S withEnterpriseEdition() {
        if (!this.standardImage) {
            throw new IllegalStateException(String.format("Cannot use enterprise version with alternative image %s.", this.getDockerImageName()));
        }
        this.setDockerImageName(DEFAULT_IMAGE_NAME.withTag(ENTERPRISE_TAG).asCanonicalNameString());
        LicenseAcceptance.assertLicenseAccepted((String)this.getDockerImageName());
        this.addEnv("NEO4J_ACCEPT_LICENSE_AGREEMENT", "yes");
        return (S)((Object)((Neo4jContainer)this.self()));
    }

    public S withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return (S)((Object)((Neo4jContainer)this.self()));
    }

    public S withoutAuthentication() {
        return this.withAdminPassword(null);
    }

    public S withDatabase(MountableFile graphDb) {
        if (!this.isNeo4jDatabaseVersionSupportingDbCopy()) {
            throw new IllegalArgumentException("Copying database folder is not supported for Neo4j instances with version 4.0 or higher.");
        }
        return (S)((Object)((Neo4jContainer)this.withCopyFileToContainer(graphDb, "/data/databases/graph.db")));
    }

    public S withPlugins(MountableFile plugins) {
        return (S)((Object)((Neo4jContainer)this.withCopyFileToContainer(plugins, "/var/lib/neo4j/plugins/")));
    }

    public S withNeo4jConfig(String key, String value) {
        this.addEnv(Neo4jContainer.formatConfigurationKey(key), value);
        return (S)((Object)((Neo4jContainer)this.self()));
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    private static String formatConfigurationKey(String plainConfigKey) {
        String prefix = "NEO4J_";
        return String.format("%s%s", "NEO4J_", plainConfigKey.replaceAll("_", "__").replaceAll("\\.", "_"));
    }

    private boolean isNeo4jDatabaseVersionSupportingDbCopy() {
        boolean versionSupportingDbCopy;
        String usedImageVersion = DockerImageName.parse((String)this.getDockerImageName()).getVersionPart();
        ComparableVersion usedComparableVersion = new ComparableVersion(usedImageVersion);
        boolean bl = versionSupportingDbCopy = usedComparableVersion.isLessThan("4.0") && usedComparableVersion.isGreaterThanOrEqualTo("2");
        if (versionSupportingDbCopy) {
            return true;
        }
        if (!usedComparableVersion.isSemanticVersion()) {
            this.logger().warn("Version {} is not a semantic version. The function \"withDatabase\" will fail.", (Object)usedImageVersion);
            this.logger().warn("Copying databases is only supported for Neo4j versions 3.5.x");
        }
        return false;
    }
}

