/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.oceanbase;

import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.oceanbase.OceanBaseJdbcUtils;
import org.testcontainers.utility.DockerImageName;

public class OceanBaseCEContainer
extends JdbcDatabaseContainer<OceanBaseCEContainer> {
    static final String NAME = "oceanbasece";
    static final String DOCKER_IMAGE_NAME = "oceanbase/oceanbase-ce";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"oceanbase/oceanbase-ce");
    private static final Integer SQL_PORT = 2881;
    private static final Integer RPC_PORT = 2882;
    private static final String DEFAULT_TEST_TENANT_NAME = "test";
    private static final String DEFAULT_USERNAME = "root";
    private static final String DEFAULT_PASSWORD = "";
    private static final String DEFAULT_DATABASE_NAME = "test";

    public OceanBaseCEContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public OceanBaseCEContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.addExposedPorts(new int[]{SQL_PORT, RPC_PORT});
    }

    public String getDriverClassName() {
        return OceanBaseJdbcUtils.getDriverClass();
    }

    public String getJdbcUrl() {
        String additionalUrlParams = this.constructUrlParameters("?", "&");
        String prefix = OceanBaseJdbcUtils.isMySQLDriver(this.getDriverClassName()) ? "jdbc:mysql://" : "jdbc:oceanbase://";
        return prefix + this.getHost() + ":" + this.getMappedPort(SQL_PORT) + "/" + "test" + additionalUrlParams;
    }

    public String getDatabaseName() {
        return "test";
    }

    public String getUsername() {
        return "root@test";
    }

    public String getPassword() {
        return DEFAULT_PASSWORD;
    }

    protected String getTestQueryString() {
        return "SELECT 1";
    }
}

