/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Optional;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;

public class OrientDBContainer
extends GenericContainer<OrientDBContainer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrientDBContainer.class);
    private static final String DEFAULT_IMAGE_NAME = "orientdb";
    private static final String DEFAULT_TAG = "3.0.24-tp3";
    private static final String DOCKER_IMAGE_NAME = "orientdb:3.0.24-tp3";
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "admin";
    private static final String DEFAULT_SERVER_PASSWORD = "root";
    private static final String DEFAULT_DATABASE_NAME = "testcontainers";
    private static final int DEFAULT_BINARY_PORT = 2424;
    private static final int DEFAULT_HTTP_PORT = 2480;
    private String databaseName;
    private String serverPassword;
    private Optional<String> scriptPath = Optional.empty();
    private OrientDB orientDB;
    private ODatabaseSession session;

    public OrientDBContainer() {
        this(DOCKER_IMAGE_NAME);
    }

    public OrientDBContainer(@NonNull String dockerImageName) {
        super(dockerImageName);
        if (dockerImageName == null) {
            throw new NullPointerException("dockerImageName is marked non-null but is null");
        }
        this.serverPassword = DEFAULT_SERVER_PASSWORD;
        this.databaseName = DEFAULT_DATABASE_NAME;
        HttpWaitStrategy waitForHttp = new HttpWaitStrategy().forPort(2480).forStatusCodeMatching(response -> response == 200);
        this.waitStrategy = new WaitAllStrategy().withStrategy((WaitStrategy)Wait.forListeningPort()).withStrategy((WaitStrategy)waitForHttp).withStartupTimeout(Duration.ofMinutes(2L));
        this.addExposedPorts(new int[]{2424, 2480});
    }

    protected void configure() {
        this.addEnv("ORIENTDB_ROOT_PASSWORD", this.serverPassword);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTestQueryString() {
        return "SELECT FROM V";
    }

    public OrientDBContainer withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return (OrientDBContainer)this.self();
    }

    public OrientDBContainer withServerPassword(String serverPassword) {
        this.serverPassword = serverPassword;
        return (OrientDBContainer)this.self();
    }

    public OrientDBContainer withScriptPath(String scriptPath) {
        this.scriptPath = Optional.of(scriptPath);
        return (OrientDBContainer)this.self();
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.orientDB = new OrientDB(this.getServerUrl(), DEFAULT_SERVER_PASSWORD, this.serverPassword, OrientDBConfig.defaultConfig());
    }

    public OrientDB getOrientDB() {
        return this.orientDB;
    }

    public String getServerUrl() {
        return "remote:" + this.getHost() + ":" + this.getMappedPort(2424);
    }

    public String getDbUrl() {
        return this.getServerUrl() + "/" + this.databaseName;
    }

    public ODatabaseSession getSession() {
        return this.getSession("admin", "admin");
    }

    public synchronized ODatabaseSession getSession(String username, String password) {
        this.orientDB.createIfNotExists(this.databaseName, ODatabaseType.PLOCAL);
        if (this.session == null) {
            this.session = this.orientDB.open(this.databaseName, username, password);
            this.scriptPath.ifPresent(path -> this.loadScript((String)path, this.session));
        }
        return this.session;
    }

    private void loadScript(String path, ODatabaseSession session) {
        try {
            URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(path);
            if (resource == null) {
                LOGGER.warn("Could not load classpath init script: {}", this.scriptPath);
                throw new RuntimeException("Could not load classpath init script: " + this.scriptPath + ". Resource not found.");
            }
            String script = IOUtils.toString((URL)resource, (Charset)StandardCharsets.UTF_8);
            session.execute("sql", script, new Object[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Could not load classpath init script: {}", this.scriptPath);
            throw new RuntimeException("Could not load classpath init script: " + this.scriptPath, e);
        }
        catch (UnsupportedOperationException e) {
            LOGGER.error("Error while executing init script: {}", this.scriptPath, (Object)e);
            throw new RuntimeException("Error while executing init script: " + this.scriptPath, e);
        }
    }
}

