/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.shaded.com.google.common.base.Strings;
import org.testcontainers.utility.DockerImageName;

public class PrestoContainer<SELF extends PrestoContainer<SELF>>
extends JdbcDatabaseContainer<SELF> {
    public static final String NAME = "presto";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"prestosql/presto");
    public static final String IMAGE = "prestosql/presto";
    public static final String DEFAULT_TAG = "329";
    public static final Integer PRESTO_PORT = 8080;
    private String username = "test";
    private String catalog = null;

    @Deprecated
    public PrestoContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public PrestoContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public PrestoContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.waitStrategy = new LogMessageWaitStrategy().withRegEx(".*======== SERVER STARTED ========.*").withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS));
        this.addExposedPort(PRESTO_PORT);
    }

    @NotNull
    protected Set<Integer> getLivenessCheckPorts() {
        return new HashSet<Integer>(this.getMappedPort(PRESTO_PORT));
    }

    public String getDriverClassName() {
        return "io.prestosql.jdbc.PrestoDriver";
    }

    public String getJdbcUrl() {
        return String.format("jdbc:presto://%s:%s/%s", this.getHost(), this.getMappedPort(PRESTO_PORT), Strings.nullToEmpty((String)this.catalog));
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return "";
    }

    public String getDatabaseName() {
        return this.catalog;
    }

    public String getTestQueryString() {
        return "SELECT count(*) FROM tpch.tiny.nation";
    }

    public SELF withUsername(String username) {
        this.username = username;
        return (SELF)((Object)((PrestoContainer)this.self()));
    }

    @Deprecated
    public SELF withPassword(String password) {
        return (SELF)((Object)((PrestoContainer)this.self()));
    }

    public SELF withDatabaseName(String dbName) {
        this.catalog = dbName;
        return (SELF)((Object)((PrestoContainer)this.self()));
    }

    public Connection createConnection() throws SQLException, JdbcDatabaseContainer.NoDriverFoundException {
        return this.createConnection("");
    }
}

