/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.r2dbc;

import io.r2dbc.spi.Closeable;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactories;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import io.r2dbc.spi.ConnectionFactoryOptions;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.StreamSupport;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.r2dbc.CancellableSubscription;
import org.testcontainers.r2dbc.ConnectionPublisher;
import org.testcontainers.r2dbc.R2DBCDatabaseContainer;
import org.testcontainers.r2dbc.R2DBCDatabaseContainerProvider;

class TestcontainersR2DBCConnectionFactory
implements ConnectionFactory,
Closeable {
    private static final AtomicLong THREAD_COUNT = new AtomicLong();
    private static final Executor EXECUTOR = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setName("testcontainers-r2dbc-" + THREAD_COUNT.getAndIncrement());
        thread.setDaemon(true);
        return thread;
    });
    private final ConnectionFactoryOptions options;
    private final R2DBCDatabaseContainerProvider containerProvider;
    private CompletableFuture<R2DBCDatabaseContainer> future;

    TestcontainersR2DBCConnectionFactory(ConnectionFactoryOptions options) {
        this.options = options;
        this.containerProvider = StreamSupport.stream(ServiceLoader.load(R2DBCDatabaseContainerProvider.class).spliterator(), false).filter(it -> it.supports(options)).findAny().orElseThrow(() -> new IllegalArgumentException("Missing provider for " + options));
    }

    public Publisher<? extends Connection> create() {
        return new ConnectionPublisher(() -> {
            if (this.future == null) {
                TestcontainersR2DBCConnectionFactory testcontainersR2DBCConnectionFactory = this;
                synchronized (testcontainersR2DBCConnectionFactory) {
                    if (this.future == null) {
                        this.future = CompletableFuture.supplyAsync(() -> {
                            R2DBCDatabaseContainer container = this.containerProvider.createContainer(this.options);
                            container.start();
                            return container;
                        }, EXECUTOR);
                    }
                }
            }
            return this.future.thenApply(it -> ConnectionFactories.find((ConnectionFactoryOptions)it.configure(this.options)));
        });
    }

    public ConnectionFactoryMetadata getMetadata() {
        return this.containerProvider.getMetadata(this.options);
    }

    public Publisher<Void> close() {
        return s -> {
            CompletableFuture<R2DBCDatabaseContainer> futureRef;
            TestcontainersR2DBCConnectionFactory testcontainersR2DBCConnectionFactory = this;
            synchronized (testcontainersR2DBCConnectionFactory) {
                futureRef = this.future;
                this.future = null;
            }
            CancellableSubscription subscription = new CancellableSubscription();
            s.onSubscribe((Subscription)subscription);
            if (futureRef == null) {
                if (!subscription.isCancelled()) {
                    s.onComplete();
                }
            } else {
                futureRef.thenAcceptAsync(Startable::stop, EXECUTOR);
                EXECUTOR.execute(() -> {
                    futureRef.cancel(true);
                    if (!subscription.isCancelled()) {
                        s.onComplete();
                    }
                });
            }
        };
    }
}

