/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.freemarker.ext.jakarta.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Map;
import org.testcontainers.shaded.freemarker.template.ObjectWrapper;
import org.testcontainers.shaded.freemarker.template.SimpleHash;
import org.testcontainers.shaded.freemarker.template.TemplateModel;
import org.testcontainers.shaded.freemarker.template.TemplateModelException;
import org.testcontainers.shaded.freemarker.template.utility.NullArgumentException;

public class AllHttpScopesHashModel
extends SimpleHash {
    private final ServletContext context;
    private final HttpServletRequest request;
    private final Map unlistedModels = new HashMap();

    public AllHttpScopesHashModel(ObjectWrapper objectWrapper, ServletContext context, HttpServletRequest request) {
        super(objectWrapper);
        NullArgumentException.check("wrapper", objectWrapper);
        this.context = context;
        this.request = request;
    }

    public void putUnlistedModel(String key, TemplateModel model) {
        this.unlistedModels.put(key, model);
    }

    @Override
    public TemplateModel get(String key) throws TemplateModelException {
        TemplateModel model = super.get(key);
        if (model != null) {
            return model;
        }
        model = (TemplateModel)this.unlistedModels.get(key);
        if (model != null) {
            return model;
        }
        Object obj = this.request.getAttribute(key);
        if (obj != null) {
            return this.wrap(obj);
        }
        HttpSession session = this.request.getSession(false);
        if (session != null && (obj = session.getAttribute(key)) != null) {
            return this.wrap(obj);
        }
        obj = this.context.getAttribute(key);
        if (obj != null) {
            return this.wrap(obj);
        }
        return this.wrap(null);
    }
}

