/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.freemarker.core;

import java.io.IOException;
import org.testcontainers.shaded.freemarker.core.BreakOrContinueException;
import org.testcontainers.shaded.freemarker.core.Case;
import org.testcontainers.shaded.freemarker.core.Environment;
import org.testcontainers.shaded.freemarker.core.EvalUtil;
import org.testcontainers.shaded.freemarker.core.Expression;
import org.testcontainers.shaded.freemarker.core.MixedContent;
import org.testcontainers.shaded.freemarker.core.ParameterRole;
import org.testcontainers.shaded.freemarker.core.ParseException;
import org.testcontainers.shaded.freemarker.core.TemplateElement;
import org.testcontainers.shaded.freemarker.template.TemplateException;

final class SwitchBlock
extends TemplateElement {
    private Case defaultCase;
    private final Expression searched;
    private int firstCaseIndex;

    SwitchBlock(Expression searched, MixedContent ignoredSectionBeforeFirstCase) {
        this.searched = searched;
        int ignoredCnt = ignoredSectionBeforeFirstCase != null ? ignoredSectionBeforeFirstCase.getChildCount() : 0;
        this.setChildBufferCapacity(ignoredCnt + 4);
        for (int i = 0; i < ignoredCnt; ++i) {
            this.addChild(ignoredSectionBeforeFirstCase.getChild(i));
        }
        this.firstCaseIndex = ignoredCnt;
    }

    void addCase(Case cas) {
        if (cas.condition == null) {
            this.defaultCase = cas;
        }
        this.addChild(cas);
    }

    @Override
    TemplateElement[] accept(Environment env) throws TemplateException, IOException {
        boolean processedCase = false;
        int ln = this.getChildCount();
        try {
            for (int i = this.firstCaseIndex; i < ln; ++i) {
                Case cas = (Case)this.getChild(i);
                boolean processCase = false;
                if (processedCase) {
                    processCase = true;
                } else if (cas.condition != null) {
                    processCase = EvalUtil.compare(this.searched, 1, "case==", cas.condition, cas.condition, env);
                }
                if (!processCase) continue;
                env.visit(cas);
                processedCase = true;
            }
            if (!processedCase && this.defaultCase != null) {
                env.visit(this.defaultCase);
            }
        }
        catch (BreakOrContinueException breakOrContinueException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected String dump(boolean canonical) {
        StringBuilder buf = new StringBuilder();
        if (canonical) {
            buf.append('<');
        }
        buf.append(this.getNodeTypeSymbol());
        buf.append(' ');
        buf.append(this.searched.getCanonicalForm());
        if (canonical) {
            buf.append('>');
            int ln = this.getChildCount();
            for (int i = 0; i < ln; ++i) {
                buf.append(this.getChild(i).getCanonicalForm());
            }
            buf.append("</").append(this.getNodeTypeSymbol()).append('>');
        }
        return buf.toString();
    }

    @Override
    String getNodeTypeSymbol() {
        return "#switch";
    }

    @Override
    int getParameterCount() {
        return 1;
    }

    @Override
    Object getParameterValue(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.searched;
    }

    @Override
    ParameterRole getParameterRole(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return ParameterRole.VALUE;
    }

    @Override
    boolean isNestedBlockRepeater() {
        return false;
    }

    @Override
    TemplateElement postParseCleanup(boolean stripWhitespace) throws ParseException {
        int i;
        TemplateElement result = super.postParseCleanup(stripWhitespace);
        int ln = this.getChildCount();
        for (i = 0; i < ln && !(this.getChild(i) instanceof Case); ++i) {
        }
        this.firstCaseIndex = i;
        return result;
    }
}

