/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.testcontainers.containers.SolrClientUtilsException;
import org.testcontainers.shaded.okhttp3.HttpUrl;
import org.testcontainers.shaded.okhttp3.MediaType;
import org.testcontainers.shaded.okhttp3.OkHttpClient;
import org.testcontainers.shaded.okhttp3.Request;
import org.testcontainers.shaded.okhttp3.RequestBody;
import org.testcontainers.shaded.okhttp3.Response;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;

public class SolrClientUtils {
    private static OkHttpClient httpClient = new OkHttpClient();

    public static void uploadConfiguration(String hostname, int port, String configurationName, URL solrConfig, URL solrSchema) throws URISyntaxException, IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("action", "UPLOAD");
        parameters.put("name", configurationName);
        HttpUrl url = SolrClientUtils.generateSolrURL(hostname, port, Arrays.asList("admin", "configs"), parameters);
        byte[] configurationZipFile = SolrClientUtils.generateConfigZipFile(solrConfig, solrSchema);
        SolrClientUtils.executePost(url, configurationZipFile);
    }

    public static void createCollection(String hostname, int port, String collectionName, String configurationName) throws URISyntaxException, IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("action", "CREATE");
        parameters.put("name", collectionName);
        parameters.put("numShards", "1");
        parameters.put("replicationFactor", "1");
        parameters.put("wt", "json");
        if (configurationName != null) {
            parameters.put("collection.configName", configurationName);
        }
        HttpUrl url = SolrClientUtils.generateSolrURL(hostname, port, Arrays.asList("admin", "collections"), parameters);
        SolrClientUtils.executePost(url, null);
    }

    private static void executePost(HttpUrl url, byte[] data) throws IOException {
        RequestBody requestBody = data == null ? RequestBody.create(MediaType.parse("text/plain"), "") : RequestBody.create(MediaType.parse("application/octet-stream"), data);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = httpClient.newCall(request).execute();
        if (!response.isSuccessful()) {
            String responseBody = "";
            if (response.body() != null) {
                responseBody = response.body().string();
                response.close();
            }
            throw new SolrClientUtilsException(response.code(), "Unable to upload binary\n" + responseBody);
        }
        if (response.body() != null) {
            response.close();
        }
    }

    private static HttpUrl generateSolrURL(String hostname, int port, List<String> pathSegments, Map<String, String> parameters) throws URISyntaxException {
        HttpUrl.Builder builder = new HttpUrl.Builder();
        builder.scheme("http");
        builder.host(hostname);
        builder.port(port);
        builder.addPathSegment("solr");
        if (pathSegments != null) {
            pathSegments.forEach(builder::addPathSegment);
        }
        parameters.forEach(builder::addQueryParameter);
        return builder.build();
    }

    private static byte[] generateConfigZipFile(URL solrConfiguration, URL solrSchema) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(bos);
        zipOutputStream.putNextEntry(new ZipEntry("solrconfig.xml"));
        IOUtils.copy((InputStream)solrConfiguration.openStream(), (OutputStream)zipOutputStream);
        zipOutputStream.closeEntry();
        if (solrSchema != null) {
            zipOutputStream.putNextEntry(new ZipEntry("schema.xml"));
            IOUtils.copy((InputStream)solrSchema.openStream(), (OutputStream)zipOutputStream);
            zipOutputStream.closeEntry();
        }
        zipOutputStream.close();
        return bos.toByteArray();
    }
}

