/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.cassandra;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.testcontainers.cassandra.CassandraDatabaseDelegate;
import org.testcontainers.cassandra.CassandraQueryWaitStrategy;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.ext.ScriptUtils;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class CassandraContainer
extends GenericContainer<CassandraContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"cassandra");
    private static final Integer CQL_PORT = 9042;
    private static final String DEFAULT_LOCAL_DATACENTER = "datacenter1";
    private static final String DEFAULT_INIT_SCRIPT_FILENAME = "init.cql";
    private static final String CONTAINER_CONFIG_LOCATION = "/etc/cassandra";
    private static final String USERNAME = "cassandra";
    private static final String PASSWORD = "cassandra";
    private String configLocation;
    private String initScriptPath;
    private String clientCertFile;
    private String clientKeyFile;

    public CassandraContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public CassandraContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.addExposedPort(CQL_PORT);
        this.withEnv("CASSANDRA_SNITCH", "GossipingPropertyFileSnitch");
        this.withEnv("JVM_OPTS", "-Dcassandra.skip_wait_for_gossip_to_settle=0 -Dcassandra.initial_token=0");
        this.withEnv("HEAP_NEWSIZE", "128M");
        this.withEnv("MAX_HEAP_SIZE", "1024M");
        this.withEnv("CASSANDRA_ENDPOINT_SNITCH", "GossipingPropertyFileSnitch");
        this.withEnv("CASSANDRA_DC", DEFAULT_LOCAL_DATACENTER);
        this.waitingFor((WaitStrategy)new CassandraQueryWaitStrategy());
    }

    protected void configure() {
        Optional.ofNullable(this.configLocation).map(MountableFile::forClasspathResource).ifPresent(mountableFile -> this.withCopyFileToContainer((MountableFile)mountableFile, CONTAINER_CONFIG_LOCATION));
        if (this.isSslRequired()) {
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.clientCertFile), "ssl/user_cert.pem");
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.clientKeyFile), "ssl/user_key.pem");
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"cqlshrc"), "/root/.cassandra/cqlshrc");
        }
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.runInitScriptIfRequired();
    }

    private void runInitScriptIfRequired() {
        if (this.initScriptPath != null) {
            try {
                MountableFile originalInitScript = MountableFile.forClasspathResource((String)this.initScriptPath);
                this.copyFileToContainer(originalInitScript, DEFAULT_INIT_SCRIPT_FILENAME);
                new CassandraDatabaseDelegate((ContainerState)this).execute(null, DEFAULT_INIT_SCRIPT_FILENAME, -1, false, false);
            }
            catch (IllegalArgumentException e) {
                this.logger().warn("Could not load classpath init script: {}", (Object)this.initScriptPath);
                throw new ScriptUtils.ScriptLoadException("Could not load classpath init script: " + this.initScriptPath + ". Resource not found.", (Throwable)e);
            }
            catch (ScriptUtils.ScriptStatementFailedException e) {
                this.logger().error("Error while executing init script: {}", (Object)this.initScriptPath, (Object)e);
                throw new ScriptUtils.UncategorizedScriptException("Error while executing init script: " + this.initScriptPath, (Exception)((Object)e));
            }
        }
    }

    public CassandraContainer withConfigurationOverride(String configLocation) {
        this.configLocation = configLocation;
        return (CassandraContainer)this.self();
    }

    public CassandraContainer withInitScript(String initScriptPath) {
        this.initScriptPath = initScriptPath;
        return (CassandraContainer)this.self();
    }

    public CassandraContainer withSsl(String clientCertFile, String clientKeyFile) {
        this.clientCertFile = clientCertFile;
        this.clientKeyFile = clientKeyFile;
        return (CassandraContainer)this.self();
    }

    boolean isSslRequired() {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.clientCertFile, this.clientKeyFile});
    }

    public String getUsername() {
        return "cassandra";
    }

    public String getPassword() {
        return "cassandra";
    }

    public InetSocketAddress getContactPoint() {
        return new InetSocketAddress(this.getHost(), (int)this.getMappedPort(CQL_PORT));
    }

    public String getLocalDatacenter() {
        return this.getEnvMap().getOrDefault("CASSANDRA_DC", DEFAULT_LOCAL_DATACENTER);
    }
}

