/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.jooq.codegen;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.testcontainers.jooq.codegen.database.DatabaseProps;
import org.testcontainers.jooq.codegen.datasource.TargetDatasource;
import org.testcontainers.jooq.codegen.jooq.JooqGenerator;
import org.testcontainers.jooq.codegen.jooq.JooqProps;
import org.testcontainers.jooq.codegen.migration.runner.FlywayRunner;
import org.testcontainers.jooq.codegen.migration.runner.LiquibaseRunner;
import org.testcontainers.jooq.codegen.migration.runner.MigrationRunner;
import org.testcontainers.jooq.codegen.migration.runner.RunnerProperties;
import org.testcontainers.jooq.codegen.util.OptionalUtils;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class Plugin
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(required=true)
    private DatabaseProps database;
    @Parameter(required=true)
    private JooqProps jooq;
    @Parameter
    private FlywayRunner flyway;
    @Parameter
    private LiquibaseRunner liquibase;
    @Inject
    private JooqGenerator jooqGenerator;

    public void execute() throws MojoExecutionException {
        if (this.jooq.skip()) {
            this.getLog().info((CharSequence)"Skipping jOOQ code generation");
            return;
        }
        if (this.database.getType() == null) {
            throw new MojoExecutionException("Property 'type' should be specified inside 'database' block");
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        URLClassLoader mavenClassloader = this.getMavenClassloader();
        try (TargetDatasource targetDatasource = TargetDatasource.createOrJoinExisting(this.jooq, this.database);){
            this.doExecute(mavenClassloader, targetDatasource);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error running jOOQ code generation tool", ex);
        }
        finally {
            this.closeClassloader(oldCL, mavenClassloader);
        }
    }

    private void doExecute(URLClassLoader mavenClassloader, TargetDatasource targetDatasource) throws Exception {
        RunnerProperties properties = new RunnerProperties(targetDatasource.getUrl(), targetDatasource.getUsername(), targetDatasource.getPassword(), targetDatasource.getDriver(), mavenClassloader, this.project);
        Thread.currentThread().setContextClassLoader(mavenClassloader);
        Optional<FlywayRunner> oFlyway = Optional.ofNullable(this.flyway);
        Optional<LiquibaseRunner> oLiquibase = Optional.ofNullable(this.liquibase);
        if (OptionalUtils.bothPresent(oFlyway, oLiquibase)) {
            this.getLog().error((CharSequence)"Incorrect configuration is provided.Plugin supports only one migration tool.\nPlease remain only flyway or liquibase.");
            throw new MojoExecutionException("Both configurations for migration tool are provided, pick either flyway or liquibase");
        }
        ((MigrationRunner)oLiquibase.or(() -> oFlyway).orElseThrow(() -> new IllegalArgumentException("Neither liquibase nor flyway provided!"))).run(properties);
        this.getLog().info((CharSequence)"Migrations applied successfully");
        this.jooqGenerator.generateSources(targetDatasource, this.jooq, this.getLog());
    }

    private void closeClassloader(ClassLoader oldCL, URLClassLoader mavenClassloader) {
        Thread.currentThread().setContextClassLoader(oldCL);
        try {
            mavenClassloader.close();
        }
        catch (Throwable e) {
            this.getLog().error((CharSequence)"Couldn't close the classloader.", e);
        }
    }

    private URLClassLoader getMavenClassloader() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getRuntimeClasspathElements();
            if (classpathElements == null) {
                classpathElements = List.of();
            }
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't create a classloader.", e);
        }
    }
}

