/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.jooq.codegen.datasource;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.VolumesFrom;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.SelinuxContext;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.containers.traits.LinkableContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.ImagePullPolicy;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.jooq.codegen.datasource.TargetDatasource;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.MountableFile;
import org.testcontainers.utility.ThrowingFunction;

public final class ContainerTargetDatasource
implements TargetDatasource {
    private final JdbcDatabaseContainer<?> container;

    public ContainerTargetDatasource(JdbcDatabaseContainer<?> container) {
        this.container = Objects.requireNonNull(container);
        this.container.setWaitStrategy((WaitStrategy)new HostPortWaitStrategy());
        this.container.start();
    }

    @Override
    public String getUrl() {
        return this.container.getJdbcUrl();
    }

    @Override
    public Driver getDriverInstance() {
        return this.container.getJdbcDriverInstance();
    }

    public String getDriverClassName() {
        return this.container.getDriverClassName();
    }

    public String getJdbcUrl() {
        return this.container.getJdbcUrl();
    }

    public String getDatabaseName() {
        return this.container.getDatabaseName();
    }

    @Override
    public String getUsername() {
        return this.container.getUsername();
    }

    @Override
    public String getPassword() {
        return this.container.getPassword();
    }

    public Object withUsername(String username) {
        return this.container.withUsername(username);
    }

    public Object withPassword(String password) {
        return this.container.withPassword(password);
    }

    public Object withDatabaseName(String dbName) {
        return this.container.withDatabaseName(dbName);
    }

    public Object withUrlParam(String paramName, String paramValue) {
        return this.container.withUrlParam(paramName, paramValue);
    }

    public Object withStartupTimeoutSeconds(int startupTimeoutSeconds) {
        return this.container.withStartupTimeoutSeconds(startupTimeoutSeconds);
    }

    public Object withConnectTimeoutSeconds(int connectTimeoutSeconds) {
        return this.container.withConnectTimeoutSeconds(connectTimeoutSeconds);
    }

    public Object withInitScript(String initScriptPath) {
        return this.container.withInitScript(initScriptPath);
    }

    public Driver getJdbcDriverInstance() throws JdbcDatabaseContainer.NoDriverFoundException {
        return this.container.getJdbcDriverInstance();
    }

    public Connection createConnection(String queryString) throws SQLException, JdbcDatabaseContainer.NoDriverFoundException {
        return this.container.createConnection(queryString);
    }

    public Connection createConnection(String queryString, Properties info) throws SQLException, JdbcDatabaseContainer.NoDriverFoundException {
        return this.container.createConnection(queryString, info);
    }

    public void setParameters(Map<String, String> parameters) {
        this.container.setParameters(parameters);
    }

    public void addParameter(String paramName, String value) {
        this.container.addParameter(paramName, value);
    }

    public void setImage(Future<String> image) {
        this.container.setImage(image);
    }

    public List<Integer> getExposedPorts() {
        return this.container.getExposedPorts();
    }

    public void setExposedPorts(List<Integer> exposedPorts) {
        this.container.setExposedPorts(exposedPorts);
    }

    public Object dependsOn(Startable ... startables) {
        return this.container.dependsOn(startables);
    }

    public Object dependsOn(List<? extends Startable> startables) {
        return this.container.dependsOn(startables);
    }

    public Object dependsOn(Iterable<? extends Startable> startables) {
        return this.container.dependsOn(startables);
    }

    public String getContainerId() {
        return this.container.getContainerId();
    }

    public void start() {
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return this.container.getLivenessCheckPortNumbers();
    }

    public Object waitingFor(WaitStrategy waitStrategy) {
        return this.container.waitingFor(waitStrategy);
    }

    public void setWaitStrategy(WaitStrategy waitStrategy) {
        this.container.setWaitStrategy(waitStrategy);
    }

    public void setCommand(String command) {
        this.container.setCommand(command);
    }

    public void setCommand(String ... commandParts) {
        this.container.setCommand(commandParts);
    }

    public Map<String, String> getEnvMap() {
        return this.container.getEnvMap();
    }

    public List<String> getEnv() {
        return this.container.getEnv();
    }

    public void setEnv(List<String> env) {
        this.container.setEnv(env);
    }

    public void addEnv(String key, String value) {
        this.container.addEnv(key, value);
    }

    public void addFileSystemBind(String hostPath, String containerPath, BindMode mode, SelinuxContext selinuxContext) {
        this.container.addFileSystemBind(hostPath, containerPath, mode, selinuxContext);
    }

    public Object withFileSystemBind(String hostPath, String containerPath, BindMode mode) {
        return this.container.withFileSystemBind(hostPath, containerPath, mode);
    }

    public Object withVolumesFrom(Container container, BindMode mode) {
        return this.container.withVolumesFrom(container, mode);
    }

    @Deprecated
    public void addLink(LinkableContainer otherContainer, String alias) {
        this.container.addLink(otherContainer, alias);
    }

    public void addExposedPort(Integer port) {
        this.container.addExposedPort(port);
    }

    public void addExposedPorts(int ... ports) {
        this.container.addExposedPorts(ports);
    }

    @Deprecated
    public Statement apply(Statement base, Description description) {
        return this.container.apply(base, description);
    }

    public Object withExposedPorts(Integer ... ports) {
        return this.container.withExposedPorts(ports);
    }

    public Object withEnv(String key, String value) {
        return this.container.withEnv(key, value);
    }

    public Object withEnv(Map<String, String> env) {
        return this.container.withEnv(env);
    }

    public Object withLabel(String key, String value) {
        return this.container.withLabel(key, value);
    }

    public Object withLabels(Map<String, String> labels) {
        return this.container.withLabels(labels);
    }

    public Object withCommand(String cmd) {
        return this.container.withCommand(cmd);
    }

    public Object withCommand(String ... commandParts) {
        return this.container.withCommand(commandParts);
    }

    public Object withExtraHost(String hostname, String ipAddress) {
        return this.container.withExtraHost(hostname, ipAddress);
    }

    public Object withNetworkMode(String networkMode) {
        return this.container.withNetworkMode(networkMode);
    }

    public Object withNetwork(Network network) {
        return this.container.withNetwork(network);
    }

    public Object withNetworkAliases(String ... aliases) {
        return this.container.withNetworkAliases(aliases);
    }

    public Object withImagePullPolicy(ImagePullPolicy imagePullPolicy) {
        return this.container.withImagePullPolicy(imagePullPolicy);
    }

    public Object withClasspathResourceMapping(String resourcePath, String containerPath, BindMode mode) {
        return this.container.withClasspathResourceMapping(resourcePath, containerPath, mode);
    }

    public Object withClasspathResourceMapping(String resourcePath, String containerPath, BindMode mode, SelinuxContext selinuxContext) {
        return this.container.withClasspathResourceMapping(resourcePath, containerPath, mode, selinuxContext);
    }

    public Object withStartupTimeout(Duration startupTimeout) {
        return this.container.withStartupTimeout(startupTimeout);
    }

    public Object withPrivilegedMode(boolean mode) {
        return this.container.withPrivilegedMode(mode);
    }

    public Object withMinimumRunningDuration(Duration minimumRunningDuration) {
        return this.container.withMinimumRunningDuration(minimumRunningDuration);
    }

    public Object withStartupCheckStrategy(StartupCheckStrategy strategy) {
        return this.container.withStartupCheckStrategy(strategy);
    }

    public Object withWorkingDirectory(String workDir) {
        return this.container.withWorkingDirectory(workDir);
    }

    public Object withCopyFileToContainer(MountableFile mountableFile, String containerPath) {
        return this.container.withCopyFileToContainer(mountableFile, containerPath);
    }

    public Object withCopyToContainer(Transferable transferable, String containerPath) {
        return this.container.withCopyToContainer(transferable, containerPath);
    }

    @Deprecated
    public String getIpAddress() {
        return this.container.getIpAddress();
    }

    public void setDockerImageName(String dockerImageName) {
        this.container.setDockerImageName(dockerImageName);
    }

    public String getDockerImageName() {
        return this.container.getDockerImageName();
    }

    @Deprecated
    public String getTestHostIpAddress() {
        return this.container.getTestHostIpAddress();
    }

    public Object withLogConsumer(Consumer<OutputFrame> consumer) {
        return this.container.withLogConsumer(consumer);
    }

    public void copyFileFromContainer(String containerPath, String destinationPath) {
        this.container.copyFileFromContainer(containerPath, destinationPath);
    }

    public Object withStartupAttempts(int attempts) {
        return this.container.withStartupAttempts(attempts);
    }

    public Object withCreateContainerCmdModifier(Consumer<CreateContainerCmd> modifier) {
        return this.container.withCreateContainerCmdModifier(modifier);
    }

    public Object withSharedMemorySize(Long bytes) {
        return this.container.withSharedMemorySize(bytes);
    }

    public Object withTmpFs(Map<String, String> mapping) {
        return this.container.withTmpFs(mapping);
    }

    public Object withReuse(boolean reusable) {
        return this.container.withReuse(reusable);
    }

    public Object withAccessToHost(boolean value) {
        return this.container.withAccessToHost(value);
    }

    public String getContainerName() {
        return this.container.getContainerName();
    }

    public List<String> getPortBindings() {
        return this.container.getPortBindings();
    }

    public List<String> getExtraHosts() {
        return this.container.getExtraHosts();
    }

    public String getNetworkMode() {
        return this.container.getNetworkMode();
    }

    public Network getNetwork() {
        return this.container.getNetwork();
    }

    public List<String> getNetworkAliases() {
        return this.container.getNetworkAliases();
    }

    public RemoteDockerImage getImage() {
        return this.container.getImage();
    }

    public Map<String, String> getLabels() {
        return this.container.getLabels();
    }

    public String[] getCommandParts() {
        return this.container.getCommandParts();
    }

    public List<Bind> getBinds() {
        return this.container.getBinds();
    }

    public boolean isPrivilegedMode() {
        return this.container.isPrivilegedMode();
    }

    public List<VolumesFrom> getVolumesFroms() {
        return this.container.getVolumesFroms();
    }

    @Deprecated
    public Map<String, LinkableContainer> getLinkedContainers() {
        return this.container.getLinkedContainers();
    }

    public StartupCheckStrategy getStartupCheckStrategy() {
        return this.container.getStartupCheckStrategy();
    }

    public int getStartupAttempts() {
        return this.container.getStartupAttempts();
    }

    public String getWorkingDirectory() {
        return this.container.getWorkingDirectory();
    }

    public Long getShmSize() {
        return this.container.getShmSize();
    }

    @Deprecated
    public Map<MountableFile, String> getCopyToFileContainerPathMap() {
        return this.container.getCopyToFileContainerPathMap();
    }

    public Set<Startable> getDependencies() {
        return this.container.getDependencies();
    }

    public DockerClient getDockerClient() {
        return this.container.getDockerClient();
    }

    public InspectContainerResponse getContainerInfo() {
        return this.container.getContainerInfo();
    }

    public List<Consumer<OutputFrame>> getLogConsumers() {
        return this.container.getLogConsumers();
    }

    public Set<Consumer<CreateContainerCmd>> getCreateContainerCmdModifiers() {
        return this.container.getCreateContainerCmdModifiers();
    }

    public Map<String, String> getTmpFsMapping() {
        return this.container.getTmpFsMapping();
    }

    public boolean isShouldBeReused() {
        return this.container.isShouldBeReused();
    }

    public boolean isHostAccessible() {
        return this.container.isHostAccessible();
    }

    public void setPortBindings(List<String> portBindings) {
        this.container.setPortBindings(portBindings);
    }

    public void setExtraHosts(List<String> extraHosts) {
        this.container.setExtraHosts(extraHosts);
    }

    public void setNetworkMode(String networkMode) {
        this.container.setNetworkMode(networkMode);
    }

    public void setNetwork(Network network) {
        this.container.setNetwork(network);
    }

    public void setNetworkAliases(List<String> networkAliases) {
        this.container.setNetworkAliases(networkAliases);
    }

    public void setLabels(Map<String, String> labels) {
        this.container.setLabels(labels);
    }

    public void setCommandParts(String[] commandParts) {
        this.container.setCommandParts(commandParts);
    }

    public void setBinds(List<Bind> binds) {
        this.container.setBinds(binds);
    }

    public void setPrivilegedMode(boolean privilegedMode) {
        this.container.setPrivilegedMode(privilegedMode);
    }

    public void setVolumesFroms(List<VolumesFrom> volumesFroms) {
        this.container.setVolumesFroms(volumesFroms);
    }

    @Deprecated
    public void setLinkedContainers(Map<String, LinkableContainer> linkedContainers) {
        this.container.setLinkedContainers(linkedContainers);
    }

    public void setStartupCheckStrategy(StartupCheckStrategy startupCheckStrategy) {
        this.container.setStartupCheckStrategy(startupCheckStrategy);
    }

    public void setStartupAttempts(int startupAttempts) {
        this.container.setStartupAttempts(startupAttempts);
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.container.setWorkingDirectory(workingDirectory);
    }

    public void setShmSize(Long shmSize) {
        this.container.setShmSize(shmSize);
    }

    @Deprecated
    public void setCopyToFileContainerPathMap(Map<MountableFile, String> copyToFileContainerPathMap) {
        this.container.setCopyToFileContainerPathMap(copyToFileContainerPathMap);
    }

    public void setLogConsumers(List<Consumer<OutputFrame>> logConsumers) {
        this.container.setLogConsumers(logConsumers);
    }

    public void setTmpFsMapping(Map<String, String> tmpFsMapping) {
        this.container.setTmpFsMapping(tmpFsMapping);
    }

    public void setHostAccessible(boolean hostAccessible) {
        this.container.setHostAccessible(hostAccessible);
    }

    public Object self() {
        return this.container.self();
    }

    public void addFileSystemBind(String hostPath, String containerPath, BindMode mode) {
        this.container.addFileSystemBind(hostPath, containerPath, mode);
    }

    public Object withFileSystemBind(String hostPath, String containerPath) {
        return this.container.withFileSystemBind(hostPath, containerPath);
    }

    public Object withEnv(String key, Function<Optional<String>, String> mapper) {
        return this.container.withEnv(key, mapper);
    }

    public void followOutput(Consumer<OutputFrame> consumer) {
        this.container.followOutput(consumer);
    }

    public void followOutput(Consumer<OutputFrame> consumer, OutputFrame.OutputType ... types) {
        this.container.followOutput(consumer, types);
    }

    @Deprecated
    public String getContainerIpAddress() {
        return this.container.getContainerIpAddress();
    }

    public String getHost() {
        return this.container.getHost();
    }

    public boolean isRunning() {
        return this.container.isRunning();
    }

    public boolean isCreated() {
        return this.container.isCreated();
    }

    public boolean isHealthy() {
        return this.container.isHealthy();
    }

    public InspectContainerResponse getCurrentContainerInfo() {
        return this.container.getCurrentContainerInfo();
    }

    public Integer getFirstMappedPort() {
        return this.container.getFirstMappedPort();
    }

    public Integer getMappedPort(int originalPort) {
        return this.container.getMappedPort(originalPort);
    }

    public List<Integer> getBoundPortNumbers() {
        return this.container.getBoundPortNumbers();
    }

    public String getLogs() {
        return this.container.getLogs();
    }

    public String getLogs(OutputFrame.OutputType ... types) {
        return this.container.getLogs(types);
    }

    public Container.ExecResult execInContainer(String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return this.container.execInContainer(command);
    }

    public Container.ExecResult execInContainer(Charset outputCharset, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return this.container.execInContainer(outputCharset, command);
    }

    public void copyFileToContainer(MountableFile mountableFile, String containerPath) {
        this.container.copyFileToContainer(mountableFile, containerPath);
    }

    public void copyFileToContainer(Transferable transferable, String containerPath) {
        this.container.copyFileToContainer(transferable, containerPath);
    }

    public <T> T copyFileFromContainer(String containerPath, ThrowingFunction<InputStream, T> function) {
        return (T)this.container.copyFileFromContainer(containerPath, function);
    }

    @Override
    public void close() throws Exception {
        this.container.close();
    }
}

