/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.jooq.codegen.migration.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.DirectoryResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.SearchPathResourceAccessor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.testcontainers.jooq.codegen.migration.runner.MigrationRunner;
import org.testcontainers.jooq.codegen.migration.runner.RunnerProperties;

public class LiquibaseRunner
implements MigrationRunner {
    @Parameter(name="liquibase.changeLogPath")
    private String changeLogPath;
    @Parameter(name="liquibase.changeLogDirectory")
    private String changeLogDirectory;
    @Parameter(name="liquibase.parameters")
    private Map<String, String> parameters;
    @Parameter(name="liquibase.defaultSchemaName")
    private String defaultSchemaName;
    @Parameter(name="liquibase.liquibaseSchemaName")
    private String liquibaseSchemaName;
    @Parameter(name="liquibase.databaseChangeLogTableName")
    private String databaseChangeLogTableName;
    @Parameter(name="liquibase.databaseChangeLogLockTableName")
    private String databaseChangeLogLockTableName;

    @Override
    public void run(RunnerProperties runnerProps) throws MojoExecutionException {
        this.setDefaultLocations(runnerProps);
        try {
            Driver driver = runnerProps.getDriverInstance();
            Properties properties = new Properties();
            properties.put("user", runnerProps.getUsername());
            properties.put("password", runnerProps.getPassword());
            Connection c = driver.connect(runnerProps.getUrl(), properties);
            Database database = this.createDatabase(c);
            ResourceAccessor accessor = this.getResourceAccessor(runnerProps);
            Liquibase liquibase = new Liquibase(this.changeLogPath, accessor, database);
            this.setParameters(liquibase);
            liquibase.update();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void setDefaultLocations(RunnerProperties runnerProps) {
        File defaultDir = runnerProps.mavenProject().getBasedir();
        if (this.changeLogPath == null) {
            this.changeLogPath = this.changeLogDirectory == null ? "src/main/resources/db/changelog/db.changelog-root.xml" : "db.changelog-root.xml";
        }
        this.changeLogDirectory = this.changeLogDirectory == null ? defaultDir.getAbsolutePath() : defaultDir.toPath().resolve(this.changeLogDirectory).toFile().getAbsolutePath();
    }

    private Database createDatabase(Connection c) throws DatabaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(c));
        if (this.defaultSchemaName != null) {
            database.setDefaultSchemaName(this.defaultSchemaName);
        }
        Optional.ofNullable(this.liquibaseSchemaName).ifPresent(arg_0 -> ((Database)database).setLiquibaseSchemaName(arg_0));
        Optional.ofNullable(this.databaseChangeLogLockTableName).ifPresent(arg_0 -> ((Database)database).setDatabaseChangeLogLockTableName(arg_0));
        Optional.ofNullable(this.databaseChangeLogTableName).ifPresent(arg_0 -> ((Database)database).setDatabaseChangeLogTableName(arg_0));
        return database;
    }

    private void setParameters(Liquibase liquibase) {
        if (this.parameters != null) {
            this.parameters.forEach((arg_0, arg_1) -> ((Liquibase)liquibase).setChangeLogParameter(arg_0, arg_1));
        }
    }

    private ResourceAccessor getResourceAccessor(RunnerProperties properties) throws FileNotFoundException {
        ArrayList<Object> resourceAccessors = new ArrayList<Object>();
        resourceAccessors.add(new ClassLoaderResourceAccessor((ClassLoader)properties.mavenClassloader()));
        resourceAccessors.add(new ClassLoaderResourceAccessor(this.getClass().getClassLoader()));
        resourceAccessors.add(new DirectoryResourceAccessor(properties.mavenProject().getBasedir()));
        ResourceAccessor[] array = (ResourceAccessor[])resourceAccessors.toArray(ResourceAccessor[]::new);
        return new SearchPathResourceAccessor(this.changeLogDirectory, array);
    }
}

