/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.neo4j;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.ComparableVersion;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class Neo4jContainer
extends GenericContainer<Neo4jContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"neo4j");
    private static final int DEFAULT_BOLT_PORT = 7687;
    private static final int DEFAULT_HTTPS_PORT = 7473;
    private static final int DEFAULT_HTTP_PORT = 7474;
    private static final String DEFAULT_ADMIN_PASSWORD = "password";
    private static final String AUTH_FORMAT = "neo4j/%s";
    private String adminPassword = "password";
    private final Set<String> labsPlugins = new HashSet<String>();
    public static final WaitStrategy WAIT_FOR_BOLT = new LogMessageWaitStrategy().withRegEx(String.format(".*Bolt enabled on .*:%d\\.\n", 7687));
    private static final WaitStrategy WAIT_FOR_HTTP = new HttpWaitStrategy().forPort(7474).forStatusCodeMatching(response -> response == 200);

    public Neo4jContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public Neo4jContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.waitingFor((WaitStrategy)new WaitAllStrategy().withStrategy(WAIT_FOR_BOLT).withStrategy(WAIT_FOR_HTTP).withStartupTimeout(Duration.ofMinutes(2L)));
        this.addExposedPorts(new int[]{7687, 7474, 7473});
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return Stream.of(7687, 7474, 7473).map(arg_0 -> ((Neo4jContainer)this).getMappedPort(arg_0)).collect(Collectors.toSet());
    }

    protected void configure() {
        this.configureAuth();
        this.configureLabsPlugins();
        this.configureWaitStrategy();
    }

    private void configureAuth() {
        String neo4jAuthEnvKey = "NEO4J_AUTH";
        if (!this.getEnvMap().containsKey(neo4jAuthEnvKey) || !DEFAULT_ADMIN_PASSWORD.equals(this.adminPassword)) {
            boolean emptyAdminPassword = this.adminPassword == null || this.adminPassword.isEmpty();
            String neo4jAuth = emptyAdminPassword ? "none" : String.format(AUTH_FORMAT, this.adminPassword);
            this.addEnv(neo4jAuthEnvKey, neo4jAuth);
        }
    }

    private void configureLabsPlugins() {
        String neo4jLabsPluginsEnvKey = "NEO4JLABS_PLUGINS";
        if (!this.getEnv().contains(neo4jLabsPluginsEnvKey) && !this.labsPlugins.isEmpty()) {
            String enabledPlugins = this.labsPlugins.stream().map(pluginName -> "\"" + pluginName + "\"").collect(Collectors.joining(","));
            this.addEnv(neo4jLabsPluginsEnvKey, "[" + enabledPlugins + "]");
        }
    }

    private void configureWaitStrategy() {
        boolean onlyHttpExposed;
        List exposedPorts = this.getExposedPorts();
        boolean boltExposed = exposedPorts.contains(7687);
        boolean httpExposed = exposedPorts.contains(7474);
        boolean onlyBoltExposed = boltExposed && !httpExposed;
        boolean bl = onlyHttpExposed = !boltExposed && httpExposed;
        if (onlyBoltExposed) {
            this.waitingFor((WaitStrategy)new WaitAllStrategy().withStrategy(WAIT_FOR_BOLT).withStartupTimeout(Duration.ofMinutes(2L)));
        } else if (onlyHttpExposed) {
            this.waitingFor((WaitStrategy)new WaitAllStrategy().withStrategy(WAIT_FOR_HTTP).withStartupTimeout(Duration.ofMinutes(2L)));
        }
    }

    public String getBoltUrl() {
        return String.format("bolt://" + this.getHost() + ":" + this.getMappedPort(7687), new Object[0]);
    }

    public String getHttpUrl() {
        return String.format("http://" + this.getHost() + ":" + this.getMappedPort(7474), new Object[0]);
    }

    public String getHttpsUrl() {
        return String.format("https://" + this.getHost() + ":" + this.getMappedPort(7473), new Object[0]);
    }

    public Neo4jContainer acceptLicense() {
        this.addEnv("NEO4J_ACCEPT_LICENSE_AGREEMENT", "yes");
        return (Neo4jContainer)this.self();
    }

    public Neo4jContainer withAdminPassword(String adminPassword) {
        if (adminPassword != null && adminPassword.length() < 8) {
            this.logger().warn("Your provided admin password is too short and will not work with Neo4j 5.3+.");
        }
        this.adminPassword = adminPassword;
        return (Neo4jContainer)this.self();
    }

    public Neo4jContainer withoutAuthentication() {
        return this.withAdminPassword(null);
    }

    public Neo4jContainer withDatabase(MountableFile graphDb) {
        if (!this.isNeo4jDatabaseVersionSupportingDbCopy()) {
            throw new IllegalArgumentException("Copying database folder is not supported for Neo4j instances with version 4.0 or higher.");
        }
        return (Neo4jContainer)this.withCopyFileToContainer(graphDb, "/data/databases/graph.db");
    }

    public Neo4jContainer withPlugins(MountableFile plugins) {
        return (Neo4jContainer)this.withCopyFileToContainer(plugins, "/var/lib/neo4j/plugins/");
    }

    public Neo4jContainer withNeo4jConfig(String key, String value) {
        this.addEnv(Neo4jContainer.formatConfigurationKey(key), value);
        return (Neo4jContainer)this.self();
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public Neo4jContainer withPlugins(String ... plugins) {
        this.labsPlugins.addAll(Arrays.asList(plugins));
        return (Neo4jContainer)this.self();
    }

    private static String formatConfigurationKey(String plainConfigKey) {
        String prefix = "NEO4J_";
        return String.format("%s%s", "NEO4J_", plainConfigKey.replaceAll("_", "__").replaceAll("\\.", "_"));
    }

    private boolean isNeo4jDatabaseVersionSupportingDbCopy() {
        boolean versionSupportingDbCopy;
        String usedImageVersion = DockerImageName.parse((String)this.getDockerImageName()).getVersionPart();
        ComparableVersion usedComparableVersion = new ComparableVersion(usedImageVersion);
        boolean bl = versionSupportingDbCopy = usedComparableVersion.isLessThan("4.0") && usedComparableVersion.isGreaterThanOrEqualTo("2");
        if (versionSupportingDbCopy) {
            return true;
        }
        if (!usedComparableVersion.isSemanticVersion()) {
            this.logger().warn("Version {} is not a semantic version. The function \"withDatabase\" will fail.", (Object)usedImageVersion);
            this.logger().warn("Copying databases is only supported for Neo4j versions 3.5.x");
        }
        return false;
    }

    public Neo4jContainer withRandomPassword() {
        return this.withAdminPassword(UUID.randomUUID().toString());
    }
}

