/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.tidb;

import java.time.Duration;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class TiDBContainer
extends JdbcDatabaseContainer<TiDBContainer> {
    static final String NAME = "tidb";
    static final String DOCKER_IMAGE_NAME = "pingcap/tidb";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"pingcap/tidb");
    private static final Integer TIDB_PORT = 4000;
    private static final int REST_API_PORT = 10080;
    private String databaseName = "test";
    private String username = "root";
    private String password = "";

    public TiDBContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public TiDBContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.addExposedPorts(new int[]{TIDB_PORT, 10080});
        this.waitingFor(new HttpWaitStrategy().forPath("/status").forPort(10080).forStatusCode(200).withStartupTimeout(Duration.ofMinutes(1L)));
    }

    @Deprecated
    @NotNull
    protected Set<Integer> getLivenessCheckPorts() {
        return super.getLivenessCheckPorts();
    }

    public String getDriverClassName() {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            return "com.mysql.cj.jdbc.Driver";
        }
        catch (ClassNotFoundException e) {
            return "com.mysql.jdbc.Driver";
        }
    }

    public String getJdbcUrl() {
        String additionalUrlParams = this.constructUrlParameters("?", "&");
        return "jdbc:mysql://" + this.getHost() + ":" + this.getMappedPort(TIDB_PORT) + "/" + this.databaseName + additionalUrlParams;
    }

    protected String constructUrlForConnection(String queryString) {
        String url = super.constructUrlForConnection(queryString);
        if (!url.contains("useSSL=")) {
            String separator = url.contains("?") ? "&" : "?";
            url = url + separator + "useSSL=false";
        }
        if (!url.contains("allowPublicKeyRetrieval=")) {
            url = url + "&allowPublicKeyRetrieval=true";
        }
        return url;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }

    public TiDBContainer withDatabaseName(String databaseName) {
        throw new UnsupportedOperationException("The TiDB docker image does not currently support this");
    }

    public TiDBContainer withUsername(String username) {
        throw new UnsupportedOperationException("The TiDB docker image does not currently support this");
    }

    public TiDBContainer withPassword(String password) {
        throw new UnsupportedOperationException("The TiDB docker image does not currently support this");
    }
}

