/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.vault;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Capability;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.traits.LinkableContainer;

public class VaultContainer<SELF extends VaultContainer<SELF>>
extends GenericContainer<SELF>
implements LinkableContainer {
    private static final String VAULT_PORT = "8200";
    private boolean vaultPortRequested = false;
    private Map<String, List<String>> secretsMap = new HashMap<String, List<String>>();

    public VaultContainer() {
        this("vault:0.7.0");
    }

    public VaultContainer(String dockerImageName) {
        super(dockerImageName);
    }

    protected void configure() {
        this.setStartupAttempts(3);
        this.withCreateContainerCmdModifier(cmd -> cmd.withCapAdd(new Capability[]{Capability.IPC_LOCK}));
        if (!this.isVaultPortRequested()) {
            this.withEnv("VAULT_ADDR", "http://0.0.0.0:8200");
        }
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.addSecrets();
    }

    private void addSecrets() {
        if (!this.secretsMap.isEmpty()) {
            try {
                this.execInContainer(this.buildExecCommand(this.secretsMap)).getStdout().contains("Success");
            }
            catch (IOException | InterruptedException e) {
                this.logger().error("Failed to add these secrets {} into Vault via exec command. Exception message: {}", this.secretsMap, (Object)e.getMessage());
            }
        }
    }

    private String[] buildExecCommand(Map<String, List<String>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        map.forEach((path, secrets) -> {
            stringBuilder.append(" && vault write " + path);
            secrets.forEach(item -> stringBuilder.append(" " + item));
        });
        return new String[]{"/bin/sh", "-c", stringBuilder.toString().substring(4)};
    }

    public SELF withVaultToken(String token) {
        this.withEnv("VAULT_DEV_ROOT_TOKEN_ID", token);
        this.withEnv("VAULT_TOKEN", token);
        return (SELF)((Object)((VaultContainer)this.self()));
    }

    public SELF withVaultPort(int port) {
        this.setVaultPortRequested(true);
        String vaultPort = String.valueOf(port);
        this.withEnv("VAULT_ADDR", "http://0.0.0.0:8200");
        this.setPortBindings(Arrays.asList(vaultPort + ":" + VAULT_PORT));
        return (SELF)((Object)((VaultContainer)this.self()));
    }

    public SELF withSecretInVault(String path, String firstSecret, String ... remainingSecrets) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(firstSecret);
        for (String secret : remainingSecrets) {
            list.add(secret);
        }
        if (this.secretsMap.containsKey(path)) {
            list.addAll(list);
        }
        this.secretsMap.putIfAbsent(path, list);
        return (SELF)((Object)((VaultContainer)this.self()));
    }

    private void setVaultPortRequested(boolean vaultPortRequested) {
        this.vaultPortRequested = vaultPortRequested;
    }

    private boolean isVaultPortRequested() {
        return this.vaultPortRequested;
    }
}

