/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.weaviate;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class WeaviateContainer
extends GenericContainer<WeaviateContainer> {
    private static final String WEAVIATE_IMAGE = "semitechnologies/weaviate";

    public WeaviateContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public WeaviateContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DockerImageName.parse((String)WEAVIATE_IMAGE)});
        this.withExposedPorts(new Integer[]{8080, 50051});
        this.withEnv("AUTHENTICATION_ANONYMOUS_ACCESS_ENABLED", "true");
        this.withEnv("PERSISTENCE_DATA_PATH", "/var/lib/weaviate");
    }

    public String getHttpHostAddress() {
        return this.getHost() + ":" + this.getMappedPort(8080);
    }
}

