/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.strategy;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.YugabyteDBYSQLContainer;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;

public final class YugabyteDBYSQLWaitStrategy
extends AbstractWaitStrategy {
    private static final Logger log = LoggerFactory.getLogger(YugabyteDBYSQLWaitStrategy.class);
    private static final String YSQL_TEST_QUERY = "SELECT 1";
    private final WaitStrategyTarget target;

    public void waitUntilReady(WaitStrategyTarget target) {
        YugabyteDBYSQLContainer container = (YugabyteDBYSQLContainer)target;
        Unreliables.retryUntilSuccess((int)((int)this.startupTimeout.getSeconds()), (TimeUnit)TimeUnit.SECONDS, () -> {
            this.getRateLimiter().doWhenReady(() -> {
                try (Connection con = container.createConnection(container.getJdbcUrl());){
                    con.createStatement().execute(YSQL_TEST_QUERY);
                }
                catch (SQLException ex) {
                    log.error("Error connecting to the database", (Throwable)ex);
                }
            });
            return true;
        });
    }

    public void waitUntilReady() {
        this.waitUntilReady(this.target);
    }

    public YugabyteDBYSQLWaitStrategy(WaitStrategyTarget target) {
        this.target = target;
    }
}

