/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Size;
import com.sun.glass.ui.monocle.MonocleWindowManager;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativeCursors;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class SoftwareCursor
extends NativeCursor {
    private ByteBuffer cursorBuffer;
    private int renderX;
    private int renderY;
    private int hotspotX;
    private int hotspotY;

    @Override
    public Size getBestSize() {
        return new Size(16, 16);
    }

    @Override
    public void setVisibility(boolean visibility) {
        if (visibility != this.isVisible) {
            this.isVisible = visibility;
            MonocleWindowManager.getInstance().repaintAll();
        }
    }

    @Override
    public void setImage(byte[] cursorImage) {
        this.cursorBuffer = ByteBuffer.allocate(cursorImage.length);
        NativeCursors.colorKeyCursor(cursorImage, this.cursorBuffer.asIntBuffer(), 32, 0);
    }

    @Override
    public void setLocation(int x, int y) {
        int renderX = x - this.hotspotX;
        int renderY = y - this.hotspotY;
        if (renderX != this.renderX || renderY != this.renderY) {
            this.renderX = renderX;
            this.renderY = renderY;
            MonocleWindowManager.getInstance().repaintAll();
        }
    }

    @Override
    public void setHotSpot(int hotspotX, int hotspotY) {
        this.hotspotX = hotspotX;
        this.hotspotY = hotspotY;
    }

    @Override
    public void shutdown() {
    }

    public int getRenderX() {
        return this.renderX;
    }

    public int getRenderY() {
        return this.renderY;
    }

    public Buffer getCursorBuffer() {
        this.cursorBuffer.clear();
        return this.cursorBuffer;
    }
}

