/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle.linux;

import com.sun.glass.ui.monocle.input.TouchState;
import com.sun.glass.ui.monocle.input.filters.AssignPointIDTouchFilter;
import com.sun.glass.ui.monocle.input.filters.LookaheadTouchFilter;
import com.sun.glass.ui.monocle.linux.LinuxEventBuffer;
import com.sun.glass.ui.monocle.linux.LinuxInputDevice;
import com.sun.glass.ui.monocle.linux.LinuxTouchProcessor;

public class LinuxStatelessMultiTouchProcessor
extends LinuxTouchProcessor {
    private static final int COORD_UNDEFINED = Integer.MIN_VALUE;

    LinuxStatelessMultiTouchProcessor(LinuxInputDevice device) {
        super(device);
        this.pipeline.addFilter(new LookaheadTouchFilter(true));
        this.pipeline.addFilter(new AssignPointIDTouchFilter());
    }

    @Override
    public void processEvents(LinuxInputDevice device) {
        LinuxEventBuffer buffer = device.getBuffer();
        this.state.clear();
        int x = Integer.MIN_VALUE;
        int y = Integer.MIN_VALUE;
        boolean touchReleased = false;
        while (buffer.hasNextEvent()) {
            block0 : switch (buffer.getEventType()) {
                case 3: {
                    int value = this.transform.getValue(buffer);
                    switch (this.transform.getAxis(buffer)) {
                        case 0: 
                        case 53: {
                            x = value;
                            break;
                        }
                        case 1: 
                        case 54: {
                            y = value;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (buffer.getEventCode()) {
                        case 330: {
                            if (buffer.getEventValue() != 0) break;
                            touchReleased = true;
                        }
                    }
                    break;
                }
                case 0: {
                    switch (buffer.getEventCode()) {
                        case 2: {
                            if (x != Integer.MIN_VALUE && y != Integer.MIN_VALUE) {
                                TouchState.Point p = this.state.addPoint(null);
                                p.id = 0;
                                p.x = x;
                                p.y = y;
                            }
                            y = Integer.MIN_VALUE;
                            x = Integer.MIN_VALUE;
                            break block0;
                        }
                        case 0: {
                            if (touchReleased) {
                                this.state.clear();
                                touchReleased = false;
                            }
                            this.pipeline.pushState(this.state);
                            this.state.clear();
                            y = Integer.MIN_VALUE;
                            x = Integer.MIN_VALUE;
                            break block0;
                        }
                    }
                }
            }
            buffer.nextEvent();
        }
        this.pipeline.flush();
    }
}

