/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle.x11;

import com.sun.glass.ui.monocle.NativePlatform;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.RunnableProcessor;
import com.sun.glass.ui.monocle.input.InputDevice;
import com.sun.glass.ui.monocle.input.InputDeviceRegistry;
import com.sun.glass.ui.monocle.input.MouseInput;
import com.sun.glass.ui.monocle.input.MouseState;
import com.sun.glass.ui.monocle.x11.X;
import com.sun.glass.ui.monocle.x11.X11Screen;

class X11InputDeviceRegistry
extends InputDeviceRegistry {
    private MouseState state;

    X11InputDeviceRegistry() {
        InputDevice device = new InputDevice(){

            @Override
            public boolean isTouch() {
                return false;
            }

            @Override
            public boolean isMultiTouch() {
                return false;
            }

            @Override
            public boolean isRelative() {
                return true;
            }

            @Override
            public boolean is5Way() {
                return false;
            }

            @Override
            public boolean isFullKeyboard() {
                return false;
            }
        };
        Thread x11InputThread = new Thread(() -> {
            NativePlatform platform = NativePlatformFactory.getNativePlatform();
            X11Screen screen = (X11Screen)platform.getScreen();
            long display = screen.getDisplay();
            long window = screen.getNativeHandle();
            RunnableProcessor runnableProcessor = platform.getRunnableProcessor();
            runnableProcessor.invokeLater(() -> this.devices.add((Object)device));
            this.state = new MouseState();
            X.XEvent event = new X.XEvent();
            while (true) {
                X.XNextEvent(display, event.p);
                if (X.XEvent.getWindow(event.p) != window) continue;
                this.processXEvent(event, runnableProcessor);
            }
        });
        x11InputThread.setName("X11 Input");
        x11InputThread.setDaemon(true);
        x11InputThread.start();
    }

    private void processXEvent(X.XEvent event, RunnableProcessor runnableProcessor) {
        switch (X.XEvent.getType(event.p)) {
            case 4: {
                X.XButtonEvent buttonEvent = new X.XButtonEvent(event);
                int button = X.XButtonEvent.getButton(buttonEvent.p);
                runnableProcessor.invokeLater(new ButtonPressProcessor(button));
                break;
            }
            case 5: {
                X.XButtonEvent buttonEvent = new X.XButtonEvent(event);
                int button = X.XButtonEvent.getButton(buttonEvent.p);
                runnableProcessor.invokeLater(new ButtonReleaseProcessor(button));
                break;
            }
            case 6: {
                X.XMotionEvent motionEvent = new X.XMotionEvent(event);
                int x = X.XMotionEvent.getX(motionEvent.p);
                int y = X.XMotionEvent.getY(motionEvent.p);
                runnableProcessor.invokeLater(new MotionProcessor(x, y));
                break;
            }
        }
    }

    private static int buttonToGlassButton(int button) {
        switch (button) {
            case 1: {
                return 212;
            }
            case 2: {
                return 214;
            }
            case 3: {
                return 213;
            }
        }
        return 211;
    }

    private class MotionProcessor
    implements Runnable {
        private int x;
        private int y;

        MotionProcessor(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public void run() {
            MouseInput.getInstance().getState(X11InputDeviceRegistry.this.state);
            X11InputDeviceRegistry.this.state.setX(this.x);
            X11InputDeviceRegistry.this.state.setY(this.y);
            MouseInput.getInstance().setState(X11InputDeviceRegistry.this.state, false);
        }
    }

    private class ButtonReleaseProcessor
    implements Runnable {
        private int button;

        ButtonReleaseProcessor(int button) {
            this.button = button;
        }

        @Override
        public void run() {
            MouseInput.getInstance().getState(X11InputDeviceRegistry.this.state);
            int glassButton = X11InputDeviceRegistry.buttonToGlassButton(this.button);
            if (glassButton != 211) {
                X11InputDeviceRegistry.this.state.releaseButton(glassButton);
            }
            MouseInput.getInstance().setState(X11InputDeviceRegistry.this.state, false);
        }
    }

    private class ButtonPressProcessor
    implements Runnable {
        private int button;

        ButtonPressProcessor(int button) {
            this.button = button;
        }

        @Override
        public void run() {
            MouseInput.getInstance().getState(X11InputDeviceRegistry.this.state);
            int glassButton = X11InputDeviceRegistry.buttonToGlassButton(this.button);
            if (glassButton != 211) {
                X11InputDeviceRegistry.this.state.pressButton(glassButton);
            }
            MouseInput.getInstance().setState(X11InputDeviceRegistry.this.state, false);
        }
    }
}

