/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.AndroidInputDevice;
import com.sun.glass.ui.monocle.AndroidInputProcessor;
import com.sun.glass.ui.monocle.InputDeviceRegistry;
import com.sun.glass.ui.monocle.KeyState;
import com.sun.glass.ui.monocle.LinuxKeyProcessor;
import com.sun.glass.ui.monocle.TouchState;
import java.security.AllPermission;
import javafx.application.Platform;

public class AndroidInputDeviceRegistry
extends InputDeviceRegistry {
    private static AndroidInputDeviceRegistry instance = new AndroidInputDeviceRegistry();
    private AndroidInputDevice androidDevice;
    private AndroidInputProcessor processor;
    private final KeyState keyState = new KeyState();

    static AndroidInputDeviceRegistry getInstance() {
        return instance;
    }

    public static void registerDevice() {
        Platform.runLater(() -> instance.createDevice());
    }

    public static void gotTouchEventFromNative(int count, int[] actions, int[] ids, int[] x, int[] y, int primary) {
        TouchState touchState = new TouchState();
        if (primary == -1) {
            System.out.println("don't add points, primary = -1");
        } else {
            for (int i = 0; i < count; ++i) {
                TouchState.Point p = new TouchState.Point();
                p.id = ids[i];
                p.x = x[i];
                p.y = y[i];
                touchState.addPoint(p);
            }
        }
        instance.gotTouchEvent(touchState);
    }

    private void gotTouchEvent(TouchState touchState) {
        if (this.androidDevice == null) {
            System.out.println("[MON] got touch event, but no registered device yet");
            Thread.dumpStack();
            return;
        }
        if (this.processor == null) {
            System.out.println("[MON] got touch event, but processor not yet initialized");
            Thread.dumpStack();
            return;
        }
        this.processor.pushEvent(touchState);
    }

    public static void gotKeyEventFromNative(int action, int linuxKey) {
        instance.gotKeyEvent(action, linuxKey);
    }

    private void gotKeyEvent(int action, int lk) {
        int vk = LinuxKeyProcessor.getVirtualKeyCode(lk);
        if (action == 0) {
            this.keyState.pressKey(vk);
        } else if (action == 1) {
            this.keyState.releaseKey(vk);
        } else {
            System.out.println("[JVDBG] ERROR, what action is this? " + action);
        }
        instance.gotKeyEvent(this.keyState);
    }

    private void gotKeyEvent(KeyState keyState) {
        this.processor.pushKeyEvent(keyState);
    }

    private AndroidInputDeviceRegistry() {
    }

    private void createDevice() {
        System.out.println("[MON] Create device");
        AndroidInputDevice device = new AndroidInputDevice();
        this.androidDevice = this.addDeviceInternal(device, "Android Touch Input");
        System.out.println("[MON] Create device done, add done");
    }

    private AndroidInputDevice addDeviceInternal(AndroidInputDevice device, String name) {
        this.processor = this.createInputProcessor(device);
        device.setInputProcessor(this.processor);
        Thread thread = new Thread(device);
        thread.setName(name);
        thread.setDaemon(true);
        thread.start();
        this.devices.add((Object)device);
        return device;
    }

    void removeDevice(AndroidInputDevice device) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new AllPermission());
        }
        this.devices.remove((Object)device);
    }

    private AndroidInputProcessor createInputProcessor(AndroidInputDevice device) {
        return new AndroidInputProcessor(device);
    }
}

