/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.AcceleratedScreen;
import com.sun.glass.ui.monocle.EGLAcceleratedScreen;
import com.sun.glass.ui.monocle.EGLCursor;
import com.sun.glass.ui.monocle.EGLScreen;
import com.sun.glass.ui.monocle.GLException;
import com.sun.glass.ui.monocle.LinuxPlatform;
import com.sun.glass.ui.monocle.LinuxSystem;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.NullCursor;
import com.sun.glass.ui.monocle.SoftwareCursor;
import java.util.ArrayList;
import java.util.List;

public class EGLPlatform
extends LinuxPlatform {
    private List<NativeScreen> screens;

    public EGLPlatform() {
        long handle;
        String lib = System.getProperty("monocle.egl.lib");
        if (lib != null && (handle = LinuxSystem.getLinuxSystem().dlopen(lib, 257)) == 0L) {
            throw new UnsatisfiedLinkError("EGLPlatform failed to load the requested library " + lib);
        }
    }

    @Override
    protected NativeCursor createCursor() {
        boolean swcursor = Boolean.getBoolean("monocle.egl.swcursor");
        NativeCursor c = useCursor ? (swcursor ? new SoftwareCursor() : new EGLCursor()) : new NullCursor();
        return this.logSelectedCursor(c);
    }

    @Override
    protected NativeScreen createScreen() {
        return new EGLScreen(0);
    }

    @Override
    protected synchronized List<NativeScreen> createScreens() {
        if (this.screens == null) {
            int numScreens = this.nGetNumberOfScreens();
            this.screens = new ArrayList<NativeScreen>(numScreens);
            for (int i = 0; i < numScreens; ++i) {
                this.screens.add(new EGLScreen(i));
            }
        }
        return this.screens;
    }

    @Override
    public synchronized AcceleratedScreen getAcceleratedScreen(int[] attributes) throws GLException {
        if (this.accScreen == null) {
            this.accScreen = new EGLAcceleratedScreen(attributes);
        }
        return this.accScreen;
    }

    private native int nGetNumberOfScreens();
}

